ALTER TABLE ADR.WAITTIME_STAGE
  DROP CONSTRAINT WT_STAGE_FK;


ALTER TABLE ADR.WAITTIME_STAGE ADD (
  CONSTRAINT WT_STAGE_FK 
  FOREIGN KEY (VCELIGIBILITY_ID) 
  REFERENCES ADR.VCELIGIBILITY (VCELIGIBILITY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WAITTIME_ARCHIVE
  DROP CONSTRAINT WTARCH_VCELIG_FK;


ALTER TABLE ADR.WAITTIME_ARCHIVE ADD (
  CONSTRAINT WTARCH_VCELIG_FK 
  FOREIGN KEY (VCELIGIBILITY_ID) 
  REFERENCES ADR.VCELIGIBILITY (VCELIGIBILITY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_MESSAGING_CASE
  DROP CONSTRAINT WKFMSGCS_WKFCASE_FK;


ALTER TABLE ADR.WKF_MESSAGING_CASE ADD (
  CONSTRAINT WKFMSGCS_WKFCASE_FK 
  FOREIGN KEY (WKF_CASE_ID) 
  REFERENCES ADR.WKF_CASE (WKF_CASE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_MESSAGING_CASE
  DROP CONSTRAINT WKFMSGCS_PK;

ALTER TABLE ADR.WKF_MESSAGING_CASE ADD (
  CONSTRAINT WKFMSGCS_PK
  PRIMARY KEY
  (WKF_MESSAGING_CASE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_MESSAGING_CASE_H
  DROP CONSTRAINT WKFMSGCSH_PK;

ALTER TABLE ADR.WKF_MESSAGING_CASE_H ADD (
  CONSTRAINT WKFMSGCSH_PK
  PRIMARY KEY
  (WKF_MESSAGING_CASE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H
  DROP CONSTRAINT WKFCSESTH_PK;

ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H ADD (
  CONSTRAINT WKFCSESTH_PK
  PRIMARY KEY
  (WKF_CASE_STATUS_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL
  DROP CONSTRAINT WKFCSESTAT_WKFCASE_FK;


ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL ADD (
  CONSTRAINT WKFCSESTAT_WKFCASE_FK 
  FOREIGN KEY (WKF_CASE_ID) 
  REFERENCES ADR.WKF_CASE (WKF_CASE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL
  DROP CONSTRAINT WKFCSESTAT_STD_WKFRQST_FK;


ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL ADD (
  CONSTRAINT WKFCSESTAT_STD_WKFRQST_FK 
  FOREIGN KEY (WKF_CASE_REQUEST_TYPE_ID) 
  REFERENCES ADRREF.STD_WORKFLOWCASEREQUEST (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL
  DROP CONSTRAINT WKFCSESTAT_STD_WKFCSST_FK;


ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL ADD (
  CONSTRAINT WKFCSESTAT_STD_WKFCSST_FK 
  FOREIGN KEY (WKF_CASE_STATUS_TYPE_ID) 
  REFERENCES ADRREF.STD_WORKFLOWCASESTATUS (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL
  DROP CONSTRAINT WKFCSESTAT_STD_WKFACTVTY_FK;


ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL ADD (
  CONSTRAINT WKFCSESTAT_STD_WKFACTVTY_FK 
  FOREIGN KEY (WKF_CASE_ACTIVITY_TYPE_ID) 
  REFERENCES ADRREF.STD_WORKFLOWCASEACTIVITY (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL
  DROP CONSTRAINT WKFCSESTAT_PK;

ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL ADD (
  CONSTRAINT WKFCSESTAT_PK
  PRIMARY KEY
  (WKF_CASE_STATUS_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_ASSIGNMENT
  DROP CONSTRAINT WKFCSASGMT_WKFCASE_FK;


ALTER TABLE ADR.WKF_CASE_ASSIGNMENT ADD (
  CONSTRAINT WKFCSASGMT_WKFCASE_FK 
  FOREIGN KEY (WKF_CASE_ID) 
  REFERENCES ADR.WKF_CASE (WKF_CASE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_ASSIGNMENT
  DROP CONSTRAINT WKFCSASGMT_PK;

ALTER TABLE ADR.WKF_CASE_ASSIGNMENT ADD (
  CONSTRAINT WKFCSASGMT_PK
  PRIMARY KEY
  (WKF_CASE_ASSIGNMENT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H
  DROP CONSTRAINT WKFCSASGH_PK;

ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H ADD (
  CONSTRAINT WKFCSASGH_PK
  PRIMARY KEY
  (WKF_CASE_ASSIGNMENT_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_COMMENTS
  DROP CONSTRAINT WKFCMTS_WKFCASE_FK;


ALTER TABLE ADR.WKF_CASE_COMMENTS ADD (
  CONSTRAINT WKFCMTS_WKFCASE_FK 
  FOREIGN KEY (WKF_CASE_ID) 
  REFERENCES ADR.WKF_CASE (WKF_CASE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_COMMENTS
  DROP CONSTRAINT WKFCMTS_PK;

ALTER TABLE ADR.WKF_CASE_COMMENTS ADD (
  CONSTRAINT WKFCMTS_PK
  PRIMARY KEY
  (WKF_CASE_COMMENT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_COMMENTS_H
  DROP CONSTRAINT WKFCMTSH_PK;

ALTER TABLE ADR.WKF_CASE_COMMENTS_H ADD (
  CONSTRAINT WKFCMTSH_PK
  PRIMARY KEY
  (WKF_CASE_COMMENT_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE
  DROP CONSTRAINT WKFCASE_WKFISUTYPE_FK;


ALTER TABLE ADR.WKF_CASE ADD (
  CONSTRAINT WKFCASE_WKFISUTYPE_FK 
  FOREIGN KEY (WKF_CASE_ISSUE_TYPE_ID) 
  REFERENCES ADRREF.STD_WKFISSUETYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE
  DROP CONSTRAINT WKFCASE_STD_WKFRQST_FK;


ALTER TABLE ADR.WKF_CASE ADD (
  CONSTRAINT WKFCASE_STD_WKFRQST_FK 
  FOREIGN KEY (WKF_CASE_REQUEST_TYPE_ID) 
  REFERENCES ADRREF.STD_WORKFLOWCASEREQUEST (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE
  DROP CONSTRAINT WKFCASE_STD_WKFCSTYPE_FK;


ALTER TABLE ADR.WKF_CASE ADD (
  CONSTRAINT WKFCASE_STD_WKFCSTYPE_FK 
  FOREIGN KEY (WKF_CASE_TYPE_ID) 
  REFERENCES ADRREF.STD_WORKFLOWCASETYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE
  DROP CONSTRAINT WKFCASE_PRSN_FK;


ALTER TABLE ADR.WKF_CASE ADD (
  CONSTRAINT WKFCASE_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.WKF_CASE
  DROP CONSTRAINT WKFCASE_PK;

ALTER TABLE ADR.WKF_CASE ADD (
  CONSTRAINT WKFCASE_PK
  PRIMARY KEY
  (WKF_CASE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_H
  DROP CONSTRAINT WKFCASEH_PK;

ALTER TABLE ADR.WKF_CASE_H ADD (
  CONSTRAINT WKFCASEH_PK
  PRIMARY KEY
  (WKF_CASE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WAITTYPE
  DROP CONSTRAINT WAITTYPE_PK;

ALTER TABLE ADR.WAITTYPE ADD (
  CONSTRAINT WAITTYPE_PK
  PRIMARY KEY
  (WAITTYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WAITTIME
  DROP CONSTRAINT WAITTIME_WAITTYPE_FK;


ALTER TABLE ADR.WAITTIME ADD (
  CONSTRAINT WAITTIME_WAITTYPE_FK 
  FOREIGN KEY (WAITTYPE_ID) 
  REFERENCES ADR.WAITTYPE (WAITTYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.WAITTIME_STAGE
  DROP CONSTRAINT WAITTIME_STAGE_WAITTYPE_FK;


ALTER TABLE ADR.WAITTIME_STAGE ADD (
  CONSTRAINT WAITTIME_STAGE_WAITTYPE_FK 
  FOREIGN KEY (WAITTYPE_ID) 
  REFERENCES ADR.WAITTYPE (WAITTYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.WAITTIME_STAGE
  DROP CONSTRAINT WAITTIME_STAGE_PK;

ALTER TABLE ADR.WAITTIME_STAGE ADD (
  CONSTRAINT WAITTIME_STAGE_PK
  PRIMARY KEY
  (RECORD_CREATED_DATE, WAITTIME_STAGE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WAITTIME_STAGE
  DROP CONSTRAINT WAITTIME_STAGE_PERSON_FK;


ALTER TABLE ADR.WAITTIME_STAGE ADD (
  CONSTRAINT WAITTIME_STAGE_PERSON_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.WAITTIME
  DROP CONSTRAINT WAITTIME_PK;

ALTER TABLE ADR.WAITTIME ADD (
  CONSTRAINT WAITTIME_PK
  PRIMARY KEY
  (RECORD_CREATED_DATE, WAITTIME_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WAITTIME
  DROP CONSTRAINT WAITTIME_PERSON_FK;


ALTER TABLE ADR.WAITTIME ADD (
  CONSTRAINT WAITTIME_PERSON_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.WAITTIME_H
  DROP CONSTRAINT WAITTIME_H_PK;

ALTER TABLE ADR.WAITTIME_H ADD (
  CONSTRAINT WAITTIME_H_PK
  PRIMARY KEY
  (WAITTIME_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WAITTIME_ARCHIVE
  DROP CONSTRAINT WAITTIME_ARCHIVE_WAITTYPE_FK;


ALTER TABLE ADR.WAITTIME_ARCHIVE ADD (
  CONSTRAINT WAITTIME_ARCHIVE_WAITTYPE_FK 
  FOREIGN KEY (WAITTYPE_ID) 
  REFERENCES ADR.WAITTYPE (WAITTYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.WAITTIME_ARCHIVE
  DROP CONSTRAINT WAITTIME_ARCHIVE_PK;

ALTER TABLE ADR.WAITTIME_ARCHIVE ADD (
  CONSTRAINT WAITTIME_ARCHIVE_PK
  PRIMARY KEY
  (RECORD_CREATED_DATE, WAITTIME_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WAITTIME_ARCHIVE
  DROP CONSTRAINT WAITTIME_ARCHIVE_PERSON_FK;


ALTER TABLE ADR.WAITTIME_ARCHIVE ADD (
  CONSTRAINT WAITTIME_ARCHIVE_PERSON_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.NCOA_ADDRESS_VERIFY_SUMMARY
  DROP CONSTRAINT VERIFYSUM_PK;

ALTER TABLE ADR.NCOA_ADDRESS_VERIFY_SUMMARY ADD (
  CONSTRAINT VERIFYSUM_PK
  PRIMARY KEY
  (NCOA_ADDRESS_VERIFY_SUMMARY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.VCESTATUSTYPE
  DROP CONSTRAINT VCESTATUSTYPE_PK;

ALTER TABLE ADR.VCESTATUSTYPE ADD (
  CONSTRAINT VCESTATUSTYPE_PK
  PRIMARY KEY
  (VCESTATUSTYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WAITTIME
  DROP CONSTRAINT VCELIG_WAITTME_FK;


ALTER TABLE ADR.WAITTIME ADD (
  CONSTRAINT VCELIG_WAITTME_FK 
  FOREIGN KEY (VCELIGIBILITY_ID) 
  REFERENCES ADR.VCELIGIBILITY (VCELIGIBILITY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.VCELIGIBILITY
  DROP CONSTRAINT VCELIGIBILITY_PK;

ALTER TABLE ADR.VCELIGIBILITY ADD (
  CONSTRAINT VCELIGIBILITY_PK
  PRIMARY KEY
  (VCELIGIBILITY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.VCELIGIBILITY_H
  DROP CONSTRAINT VCELIGIBILITY_H_PK;

ALTER TABLE ADR.VCELIGIBILITY_H ADD (
  CONSTRAINT VCELIGIBILITY_H_PK
  PRIMARY KEY
  (VCELIGIBILITY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.VCELIGIBILITY
  DROP CONSTRAINT VCEELGB_VCESTATS_FK;


ALTER TABLE ADR.VCELIGIBILITY ADD (
  CONSTRAINT VCEELGB_VCESTATS_FK 
  FOREIGN KEY (VCESTATUSTYPE_ID) 
  REFERENCES ADR.VCESTATUSTYPE (VCESTATUSTYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.VCELIGIBILITY
  DROP CONSTRAINT VCEELGB_PRSN_FK;


ALTER TABLE ADR.VCELIGIBILITY ADD (
  CONSTRAINT VCEELGB_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.VCADMISTATUS_TYPE
  DROP CONSTRAINT VCADMISTATUS_TYPE_PK;

ALTER TABLE ADR.VCADMISTATUS_TYPE ADD (
  CONSTRAINT VCADMISTATUS_TYPE_PK
  PRIMARY KEY
  (VCADMISTATUS_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.VCADMIN
  DROP CONSTRAINT VCADMIN_VCEADMINSTATS_FK;


ALTER TABLE ADR.VCADMIN ADD (
  CONSTRAINT VCADMIN_VCEADMINSTATS_FK 
  FOREIGN KEY (VCADMISTATUS_TYPE_ID) 
  REFERENCES ADR.VCADMISTATUS_TYPE (VCADMISTATUS_TYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.VCADMIN
  DROP CONSTRAINT VCADMIN_PRSON_FK;


ALTER TABLE ADR.VCADMIN ADD (
  CONSTRAINT VCADMIN_PRSON_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.VCADMIN
  DROP CONSTRAINT VCADMIN_PK;

ALTER TABLE ADR.VCADMIN ADD (
  CONSTRAINT VCADMIN_PK
  PRIMARY KEY
  (VCADMIN_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.VCADMIN_H
  DROP CONSTRAINT VCADMIN_H_PK;

ALTER TABLE ADR.VCADMIN_H ADD (
  CONSTRAINT VCADMIN_H_PK
  PRIMARY KEY
  (VCADMIN_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL
  DROP CONSTRAINT VAPRSNCLAS_PRSN_FK;


ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL ADD (
  CONSTRAINT VAPRSNCLAS_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL
  DROP CONSTRAINT VAPRSNCLAS_PK;

ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL ADD (
  CONSTRAINT VAPRSNCLAS_PK
  PRIMARY KEY
  (VA_PERSON_CLASS_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H
  DROP CONSTRAINT VAPRSNCLAH_PK;

ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H ADD (
  CONSTRAINT VAPRSNCLAH_PK
  PRIMARY KEY
  (VA_PERSON_CLASS_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL
  DROP CONSTRAINT VAPERDVSN_PRSN_FK;


ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL ADD (
  CONSTRAINT VAPERDVSN_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL
  DROP CONSTRAINT VAPERDVSN_PK;

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL ADD (
  CONSTRAINT VAPERDVSN_PK
  PRIMARY KEY
  (VA_PERSON_DIVISION_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H
  DROP CONSTRAINT VAPERDVSNH_PK;

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H ADD (
  CONSTRAINT VAPERDVSNH_PK
  PRIMARY KEY
  (VA_PERSON_DIVISION_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_PERMISSION_SETS_H
  DROP CONSTRAINT USRPERMSTH_PK;

ALTER TABLE ADR.USER_PERMISSION_SETS_H ADD (
  CONSTRAINT USRPERMSTH_PK
  PRIMARY KEY
  (USER_PERMISSION_SET_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_PERMISSIONS_H
  DROP CONSTRAINT USRPERMH_PK;

ALTER TABLE ADR.USER_PERMISSIONS_H ADD (
  CONSTRAINT USRPERMH_PK
  PRIMARY KEY
  (USER_PERMISSIONS_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.USERS
  DROP CONSTRAINT USER_PK;

ALTER TABLE ADR.USERS ADD (
  CONSTRAINT USER_PK
  PRIMARY KEY
  (USERID)
  ENABLE VALIDATE);
ALTER TABLE ADR.USERS
  DROP CONSTRAINT USER_1_UK2_UK;

ALTER TABLE ADR.USERS ADD (
  CONSTRAINT USER_1_UK2_UK
  UNIQUE (USERNAME)
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_ROLES
  DROP CONSTRAINT USERROLE_USER_1_FK;


ALTER TABLE ADR.USER_ROLES ADD (
  CONSTRAINT USERROLE_USER_1_FK 
  FOREIGN KEY (USERID) 
  REFERENCES ADR.USERS (USERID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_ROLES
  DROP CONSTRAINT USERROLE_ROLE_FK;


ALTER TABLE ADR.USER_ROLES ADD (
  CONSTRAINT USERROLE_ROLE_FK 
  FOREIGN KEY (ROLE_ID) 
  REFERENCES ADR.ROLES (ROLE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_ROLES
  DROP CONSTRAINT USERROLE_PK;

ALTER TABLE ADR.USER_ROLES ADD (
  CONSTRAINT USERROLE_PK
  PRIMARY KEY
  (USER_ROLE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_ROLES_H
  DROP CONSTRAINT USERROLEH_PK;

ALTER TABLE ADR.USER_ROLES_H ADD (
  CONSTRAINT USERROLEH_PK
  PRIMARY KEY
  (USER_ROLES_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_PERMISSIONS
  DROP CONSTRAINT USERPERM_USER_1_FK;


ALTER TABLE ADR.USER_PERMISSIONS ADD (
  CONSTRAINT USERPERM_USER_1_FK 
  FOREIGN KEY (USERID) 
  REFERENCES ADR.USERS (USERID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_PERMISSIONS
  DROP CONSTRAINT USERPERM_STD_PERM_FK;


ALTER TABLE ADR.USER_PERMISSIONS ADD (
  CONSTRAINT USERPERM_STD_PERM_FK 
  FOREIGN KEY (PERMISSION_TYPE_ID) 
  REFERENCES ADRREF.STD_PERMISSIONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_PERMISSIONS
  DROP CONSTRAINT USERPERM_PK;

ALTER TABLE ADR.USER_PERMISSIONS ADD (
  CONSTRAINT USERPERM_PK
  PRIMARY KEY
  (USER_PERMISSION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_PERMISSION_SETS
  DROP CONSTRAINT USERPERMST_USER_1_FK;


ALTER TABLE ADR.USER_PERMISSION_SETS ADD (
  CONSTRAINT USERPERMST_USER_1_FK 
  FOREIGN KEY (USERID) 
  REFERENCES ADR.USERS (USERID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_PERMISSION_SETS
  DROP CONSTRAINT USERPERMST_PK;

ALTER TABLE ADR.USER_PERMISSION_SETS ADD (
  CONSTRAINT USERPERMST_PK
  PRIMARY KEY
  (USER_PERMISSION_SET_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_PERMISSION_SETS
  DROP CONSTRAINT USERPERMST_PERMSET_FK;


ALTER TABLE ADR.USER_PERMISSION_SETS ADD (
  CONSTRAINT USERPERMST_PERMSET_FK 
  FOREIGN KEY (PERMISSION_SET_ID) 
  REFERENCES ADR.PERMISSION_SET (PERMISSION_SET_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_LOGIN
  DROP CONSTRAINT USERLOGIN_USER_1_FK;


ALTER TABLE ADR.USER_LOGIN ADD (
  CONSTRAINT USERLOGIN_USER_1_FK 
  FOREIGN KEY (USERID) 
  REFERENCES ADR.USERS (USERID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_LOGIN
  DROP CONSTRAINT USERLOGIN_PK;

ALTER TABLE ADR.USER_LOGIN ADD (
  CONSTRAINT USERLOGIN_PK
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_LOGIN_H
  DROP CONSTRAINT USERLOGINH_PK;

ALTER TABLE ADR.USER_LOGIN_H ADD (
  CONSTRAINT USERLOGINH_PK
  PRIMARY KEY
  (USER_LOGIN_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.USERS_H
  DROP CONSTRAINT USERH_PK;

ALTER TABLE ADR.USERS_H ADD (
  CONSTRAINT USERH_PK
  PRIMARY KEY
  (USERS_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.TRANSMISSION_TYPE
  DROP CONSTRAINT TRNTYP_PK;

ALTER TABLE ADR.TRANSMISSION_TYPE ADD (
  CONSTRAINT TRNTYP_PK
  PRIMARY KEY
  (TRANSMISSION_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.IRS_TRANSMISSION_LOG
  DROP CONSTRAINT TRNSSTAT_IRSTRNSLOG_FK;


ALTER TABLE ADR.IRS_TRANSMISSION_LOG ADD (
  CONSTRAINT TRNSSTAT_IRSTRNSLOG_FK 
  FOREIGN KEY (TRANSMISSION_STATUS_ID) 
  REFERENCES ADR.TRANSMISSION_STATUS (TRANSMISSION_STATUS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.GEOCODE_TRANSMIT
  DROP CONSTRAINT TRNSMT_PRSN_FK;


ALTER TABLE ADR.GEOCODE_TRANSMIT ADD (
  CONSTRAINT TRNSMT_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.TRANSMISSION_STATUS
  DROP CONSTRAINT TRANSMISSION_STATUS_ID_PK;

ALTER TABLE ADR.TRANSMISSION_STATUS ADD (
  CONSTRAINT TRANSMISSION_STATUS_ID_PK
  PRIMARY KEY
  (TRANSMISSION_STATUS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.TPA_TRANSMISSION_LOG
  DROP CONSTRAINT TPA_TRANS_FILETRNSF_ID_FK;


ALTER TABLE ADR.TPA_TRANSMISSION_LOG ADD (
  CONSTRAINT TPA_TRANS_FILETRNSF_ID_FK 
  FOREIGN KEY (CCN_FILETRANSFER_ID) 
  REFERENCES ADR.CCN_FILETRANSFER (CCN_FILETRANSFER_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.TPA_TRANSMISSION_LOG
  DROP CONSTRAINT TPA_TRANSMISSION_LOG_PK;

ALTER TABLE ADR.TPA_TRANSMISSION_LOG ADD (
  CONSTRAINT TPA_TRANSMISSION_LOG_PK
  PRIMARY KEY
  (TPA_TRANSMISSION_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.TPA_TRANSMISSION_LOG
  DROP CONSTRAINT TPA_TRANSLOG_PERSON_ID_FK;


ALTER TABLE ADR.TPA_TRANSMISSION_LOG ADD (
  CONSTRAINT TPA_TRANSLOG_PERSON_ID_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.TITLE_38_CARE_H
  DROP CONSTRAINT TITLE_38_CARE_H_PK;

ALTER TABLE ADR.TITLE_38_CARE_H ADD (
  CONSTRAINT TITLE_38_CARE_H_PK
  PRIMARY KEY
  (TITLE_38_CARE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.TITLE_38_CARE
  DROP CONSTRAINT TITLE38_LKUPTYPE_FK;


ALTER TABLE ADR.TITLE_38_CARE ADD (
  CONSTRAINT TITLE38_LKUPTYPE_FK 
  FOREIGN KEY (LOOKUP_TYPE_ID) 
  REFERENCES ADR.LOOKUP_TYPE (LOOKUP_TYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SERVICE_CONNECTED
  DROP CONSTRAINT SVCCON_PRSN_FK;


ALTER TABLE ADR.SERVICE_CONNECTED ADD (
  CONSTRAINT SVCCON_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SERVICE_CONNECTED
  DROP CONSTRAINT SVCCON_PK;

ALTER TABLE ADR.SERVICE_CONNECTED ADD (
  CONSTRAINT SVCCON_PK
  PRIMARY KEY
  (SERVICE_CONNECTED_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SERVICE_CONNECTED_H
  DROP CONSTRAINT SVCCONH_PK;

ALTER TABLE ADR.SERVICE_CONNECTED_H ADD (
  CONSTRAINT SVCCONH_PK
  PRIMARY KEY
  (SERVICE_CONNECTED_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.STOP_COM_RSN_TYPE
  DROP CONSTRAINT STOP_COM_RSN_TYPE_PK;

ALTER TABLE ADR.STOP_COM_RSN_TYPE ADD (
  CONSTRAINT STOP_COM_RSN_TYPE_PK
  PRIMARY KEY
  (STOP_COM_RSN_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON
  DROP CONSTRAINT STOP_COM_RSN_TYPE_ID_FK;


ALTER TABLE ADR.PERSON ADD (
  CONSTRAINT STOP_COM_RSN_TYPE_ID_FK 
  FOREIGN KEY (STOP_COM_RSN_TYPE_ID) 
  REFERENCES ADR.STOP_COM_RSN_TYPE (STOP_COM_RSN_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME
  DROP CONSTRAINT STD_HLTHBENEFITPLANTYPEID_FK;


ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME ADD (
  CONSTRAINT STD_HLTHBENEFITPLANTYPEID_FK 
  FOREIGN KEY (STD_HLTHBENEFITPLANTYPE_ID) 
  REFERENCES ADRREF.STD_HLTHBENEFITPLANTYPE (ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CL_VERIFICATION_METHOD
  DROP CONSTRAINT STD_CLVERIFTYP_CLVERMETH_FK;


ALTER TABLE ADR.CL_VERIFICATION_METHOD ADD (
  CONSTRAINT STD_CLVERIFTYP_CLVERMETH_FK 
  FOREIGN KEY (CL_VERIFICATION_METHOD_CODE) 
  REFERENCES ADRREF.STD_CLVERIFICATIONTYPE (ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE
  DROP CONSTRAINT STDLNGCD_PRSNPREFLNG_FK;


ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE ADD (
  CONSTRAINT STDLNGCD_PRSNPREFLNG_FK 
  FOREIGN KEY (STD_LANGUAGECODE_ID) 
  REFERENCES ADRREF.STD_LANGUAGECODE (ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SSN
  DROP CONSTRAINT SSN_PRSN_FK;


ALTER TABLE ADR.SSN ADD (
  CONSTRAINT SSN_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN
  DROP CONSTRAINT SSN_PRSNREL_FK;


ALTER TABLE ADR.SSN ADD (
  CONSTRAINT SSN_PRSNREL_FK 
  FOREIGN KEY (PERSON_RELATION_ID) 
  REFERENCES ADR.PERSON_RELATION (PERSON_RELATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.SSN
  DROP CONSTRAINT SSN_PK;

ALTER TABLE ADR.SSN ADD (
  CONSTRAINT SSN_PK
  PRIMARY KEY
  (SSN_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SSN_VERIFICATION
  DROP CONSTRAINT SSNVERIFY_PK;

ALTER TABLE ADR.SSN_VERIFICATION ADD (
  CONSTRAINT SSNVERIFY_PK
  PRIMARY KEY
  (SSN_VERIFICATION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SSN_VERIFICATION_DETAIL
  DROP CONSTRAINT SSNVERFYDT_SSNVERIFY_FK;


ALTER TABLE ADR.SSN_VERIFICATION_DETAIL ADD (
  CONSTRAINT SSNVERFYDT_SSNVERIFY_FK 
  FOREIGN KEY (SSN_VERIFICATION_ID) 
  REFERENCES ADR.SSN_VERIFICATION (SSN_VERIFICATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.SSN_VERIFICATION_DETAIL
  DROP CONSTRAINT SSNVERFYDT_PRSN_FK;


ALTER TABLE ADR.SSN_VERIFICATION_DETAIL ADD (
  CONSTRAINT SSNVERFYDT_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN_VERIFICATION_DETAIL
  DROP CONSTRAINT SSNVERFYDT_PK;

ALTER TABLE ADR.SSN_VERIFICATION_DETAIL ADD (
  CONSTRAINT SSNVERFYDT_PK
  PRIMARY KEY
  (SSN_VERIFICATION_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SSN_H
  DROP CONSTRAINT SSNH_PK;

ALTER TABLE ADR.SSN_H ADD (
  CONSTRAINT SSNH_PK
  PRIMARY KEY
  (SSN_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTWKMNTH_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTWKMNTH_FK 
  FOREIGN KEY (RPT_WEEK_OF_MONTH_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTWEEKOFMONTHTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTSTDRPT_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTSTDRPT_FK 
  FOREIGN KEY (RPT_STANDARD_REPORT_ID) 
  REFERENCES ADRREF.STD_RPTSTANDARDREPORTS (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTSITEDSP_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTSITEDSP_FK 
  FOREIGN KEY (RPT_SITE_DISPLAY_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTSITEDISPLAYTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTSCHED_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTSCHED_FK 
  FOREIGN KEY (RPT_SCHEDULE_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTSCHEDULETYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTQRTRLST_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTQRTRLST_FK 
  FOREIGN KEY (RPT_QUARTER_LIST_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTQUARTERLIST (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTPERIOD_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTPERIOD_FK 
  FOREIGN KEY (RPT_PERIOD_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTPERIODTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTOUTFILE_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTOUTFILE_FK 
  FOREIGN KEY (RPT_OUTPUT_FILE_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTOUTPUTFILETYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTMTHLST_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTMTHLST_FK 
  FOREIGN KEY (RPT_MONTH_LIST_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTMONTHLIST (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTMNTHDAY_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTMNTHDAY_FK 
  FOREIGN KEY (RPT_DAY_OF_MONTH_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDAYOFMONTHTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTFREQTYP_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTFREQTYP_FK 
  FOREIGN KEY (RPT_RUN_FREQUENCY_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTRUNFREQUENCYTYP (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTFORMAT_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTFORMAT_FK 
  FOREIGN KEY (RPT_OUTPUT_FORMAT_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTOUTFORMATTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTEXCPT_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTEXCPT_FK 
  FOREIGN KEY (RPT_EXCEPTION_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTEXCEPTIONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTENRLPRSTAT_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTENRLPRSTAT_FK 
  FOREIGN KEY (RPT_ENROLLPRSTAT_ID) 
  REFERENCES ADRREF.STD_REPORTENROLLPRSTAT (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTDYWKTYP_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTDYWKTYP_FK 
  FOREIGN KEY (RPT_DAY_OF_WEEK_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDAYOFWEEKTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTDTLFOR_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTDTLFOR_FK 
  FOREIGN KEY (RPT_DETAIL_FOR_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDETAILFORTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTDTLBY_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTDTLBY_FK 
  FOREIGN KEY (RPT_DETAIL_BY_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDETAILBYTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTDAYQRTR_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTDAYQRTR_FK 
  FOREIGN KEY (RPT_DAY_OF_QUARTER_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDAYOFQUARTERTYP (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR
  DROP CONSTRAINT SP_FAC_STD_CLVERIFTYP_FK;


ALTER TABLE ADR.SPECIAL_FACTOR ADD (
  CONSTRAINT SP_FAC_STD_CLVERIFTYP_FK 
  FOREIGN KEY (CL_VERIFICATION_METHOD_CODE) 
  REFERENCES ADRREF.STD_CLVERIFICATIONTYPE (ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR
  DROP CONSTRAINT SP_FAC_STD_CLSRCOFCHNG_FK;


ALTER TABLE ADR.SPECIAL_FACTOR ADD (
  CONSTRAINT SP_FAC_STD_CLSRCOFCHNG_FK 
  FOREIGN KEY (CL_SOURCE_OF_CHANGE) 
  REFERENCES ADRREF.STD_CLSOURCEOFCHANGE (ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR
  DROP CONSTRAINT SPECFACT_PRSN_FK;


ALTER TABLE ADR.SPECIAL_FACTOR ADD (
  CONSTRAINT SPECFACT_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR
  DROP CONSTRAINT SPECFACT_PK;

ALTER TABLE ADR.SPECIAL_FACTOR ADD (
  CONSTRAINT SPECFACT_PK
  PRIMARY KEY
  (SPECIAL_FACTOR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR_H
  DROP CONSTRAINT SPECFACTH_PK;

ALTER TABLE ADR.SPECIAL_FACTOR_H ADD (
  CONSTRAINT SPECFACTH_PK
  PRIMARY KEY
  (SPECIAL_FACTOR_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CL_VERIFICATION_METHOD
  DROP CONSTRAINT SPC_FAC_CL_VER_METH_FK;


ALTER TABLE ADR.CL_VERIFICATION_METHOD ADD (
  CONSTRAINT SPC_FAC_CL_VER_METH_FK 
  FOREIGN KEY (SPECIAL_FACTOR_ID) 
  REFERENCES ADR.SPECIAL_FACTOR (SPECIAL_FACTOR_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT
  DROP CONSTRAINT SITERECENR_PRSN_FK;


ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT ADD (
  CONSTRAINT SITERECENR_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT
  DROP CONSTRAINT SITERECENR_PK;

ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT ADD (
  CONSTRAINT SITERECENR_PK
  PRIMARY KEY
  (SITE_RECEIVED_ENROLLMENT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H
  DROP CONSTRAINT SITERECENH_PK;

ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H ADD (
  CONSTRAINT SITERECENH_PK
  PRIMARY KEY
  (SITE_RECEIVED_ENROLLMENT_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H
  DROP CONSTRAINT SITERCVELH_PK;

ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H ADD (
  CONSTRAINT SITERCVELH_PK
  PRIMARY KEY
  (SITE_RECEIVED_ELIGIBILITY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY
  DROP CONSTRAINT SITERCVELG_PRSN_FK;


ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY ADD (
  CONSTRAINT SITERCVELG_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY
  DROP CONSTRAINT SITERCVELG_PK;

ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY ADD (
  CONSTRAINT SITERCVELG_PK
  PRIMARY KEY
  (SITE_RECEIVED_ELIGIBILITY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SIGNATURE_IMAGE
  DROP CONSTRAINT SIGNATURE_PRSN_FK;


ALTER TABLE ADR.SIGNATURE_IMAGE ADD (
  CONSTRAINT SIGNATURE_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SIGNATURE_IMAGE
  DROP CONSTRAINT SIGNATURE_PK;

ALTER TABLE ADR.SIGNATURE_IMAGE ADD (
  CONSTRAINT SIGNATURE_PK
  PRIMARY KEY
  (SIGNATURE_IMAGE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SIGNATURE_IMAGE_H
  DROP CONSTRAINT SIGNATUREH_PK;

ALTER TABLE ADR.SIGNATURE_IMAGE_H ADD (
  CONSTRAINT SIGNATUREH_PK
  PRIMARY KEY
  (SIGNATURE_IMAGE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SHAD_REGISTRY
  DROP CONSTRAINT SHADRGSTRY_REGTRAIT_FK;


ALTER TABLE ADR.SHAD_REGISTRY ADD (
  CONSTRAINT SHADRGSTRY_REGTRAIT_FK 
  FOREIGN KEY (REGISTRY_TRAIT_ID) 
  REFERENCES ADR.REGISTRY_TRAIT (REGISTRY_TRAIT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SHAD_REGISTRY
  DROP CONSTRAINT SHADRGSTRY_PRSN_FK;


ALTER TABLE ADR.SHAD_REGISTRY ADD (
  CONSTRAINT SHADRGSTRY_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SHAD_REGISTRY
  DROP CONSTRAINT SHADRGSTRY_PK;

ALTER TABLE ADR.SHAD_REGISTRY ADD (
  CONSTRAINT SHADRGSTRY_PK
  PRIMARY KEY
  (SHAD_REGISTRY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SHAD_REGISTRY_H
  DROP CONSTRAINT SHADRGSTRH_PK;

ALTER TABLE ADR.SHAD_REGISTRY_H ADD (
  CONSTRAINT SHADRGSTRH_PK
  PRIMARY KEY
  (SHAD_REGISTRY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL
  DROP CONSTRAINT SHADREGDTL_SHADRGSTRY_FK;


ALTER TABLE ADR.SHAD_REGISTRY_DETAIL ADD (
  CONSTRAINT SHADREGDTL_SHADRGSTRY_FK 
  FOREIGN KEY (SHAD_REGISTRY_ID) 
  REFERENCES ADR.SHAD_REGISTRY (SHAD_REGISTRY_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL
  DROP CONSTRAINT SHADREGDTL_PK;

ALTER TABLE ADR.SHAD_REGISTRY_DETAIL ADD (
  CONSTRAINT SHADREGDTL_PK
  PRIMARY KEY
  (SHAD_REGISTRY_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H
  DROP CONSTRAINT SHADREGDH_PK;

ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H ADD (
  CONSTRAINT SHADREGDH_PK
  PRIMARY KEY
  (SHAD_REGISTRY_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SELF_IDENTIFIED_GENDER
  DROP CONSTRAINT SELF_IDENTIFIED_GENDER_PK;

ALTER TABLE ADR.SELF_IDENTIFIED_GENDER ADD (
  CONSTRAINT SELF_IDENTIFIED_GENDER_PK
  PRIMARY KEY
  (SELF_IDENTIFIED_GENDER_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SEEDING
  DROP CONSTRAINT SEEDING_PK;

ALTER TABLE ADR.SEEDING ADD (
  CONSTRAINT SEEDING_PK
  PRIMARY KEY
  (SEEDING_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SCHEDRPT_USER_1_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SCHEDRPT_USER_1_FK 
  FOREIGN KEY (USERID) 
  REFERENCES ADR.USERS (USERID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SCHEDRPT_RPTWRKITM_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SCHEDRPT_RPTWRKITM_FK 
  FOREIGN KEY (RPT_WORK_ITEM_STATUS_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTWORKITEMSTTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SCHEDRPT_RPTDIVTYPE_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SCHEDRPT_RPTDIVTYPE_FK 
  FOREIGN KEY (RPT_DIVISION_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDIVISIONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SCHEDRPT_PK;

ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SCHEDRPT_PK
  PRIMARY KEY
  (RPT_SCHEDULED_REPORT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE
  DROP CONSTRAINT R_1065;


ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE ADD (
  CONSTRAINT R_1065 
  FOREIGN KEY (HANDBOOK_BATCH_REQUEST_ID) 
  REFERENCES ADR.HANDBOOK_BATCH_REQUEST (HANDBOOK_BATCH_REQUEST_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST
  DROP CONSTRAINT R_1064;


ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST ADD (
  CONSTRAINT R_1064 
  FOREIGN KEY (STD_HANDBOOKBATCHREQUESTSTA_ID) 
  REFERENCES ADRREF.STD_HANDBOOKBATCHREQUESTSTATUS (ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN
  DROP CONSTRAINT R_1063;


ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN ADD (
  CONSTRAINT R_1063 
  FOREIGN KEY (HANDBOOK_BATCH_REQUEST_ID) 
  REFERENCES ADR.HANDBOOK_BATCH_REQUEST (HANDBOOK_BATCH_REQUEST_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP
  DROP CONSTRAINT R_1062;


ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP ADD (
  CONSTRAINT R_1062 
  FOREIGN KEY (HANDBOOK_BATCH_REQUEST_ID) 
  REFERENCES ADR.HANDBOOK_BATCH_REQUEST (HANDBOOK_BATCH_REQUEST_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BATCH_REQUEST_FACILITY
  DROP CONSTRAINT R_1061;


ALTER TABLE ADR.BATCH_REQUEST_FACILITY ADD (
  CONSTRAINT R_1061 
  FOREIGN KEY (HANDBOOK_BATCH_REQUEST_ID) 
  REFERENCES ADR.HANDBOOK_BATCH_REQUEST (HANDBOOK_BATCH_REQUEST_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS
  DROP CONSTRAINT R_1060;


ALTER TABLE ADR.HANDBOOK_MAIL_STATUS ADD (
  CONSTRAINT R_1060 
  FOREIGN KEY (STD_HANDBOOKMAILSTATTYPE_ID) 
  REFERENCES ADRREF.STD_HANDBOOKMAILSTATTYPE (ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_DOCUMENT
  DROP CONSTRAINT R_1059;


ALTER TABLE ADR.HANDBOOK_DOCUMENT ADD (
  CONSTRAINT R_1059 
  FOREIGN KEY (HANDBOOK_MAIL_STATUS_ID) 
  REFERENCES ADR.HANDBOOK_MAIL_STATUS (HANDBOOK_MAIL_STATUS_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS
  DROP CONSTRAINT R_1058;


ALTER TABLE ADR.HANDBOOK_MAIL_STATUS ADD (
  CONSTRAINT R_1058 
  FOREIGN KEY (STD_COMREJECTREASONTYPE_ID) 
  REFERENCES ADRREF.STD_COMREJECTREASONTYPE (ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS
  DROP CONSTRAINT R_1057;


ALTER TABLE ADR.HANDBOOK_MAIL_STATUS ADD (
  CONSTRAINT R_1057 
  FOREIGN KEY (HANDBOOK_MAIL_QUEUE_ID) 
  REFERENCES ADR.HANDBOOK_MAIL_QUEUE (HANDBOOK_MAIL_QUEUE_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE
  DROP CONSTRAINT R_1053;


ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE ADD (
  CONSTRAINT R_1053 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST
  DROP CONSTRAINT R_1051;


ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST ADD (
  CONSTRAINT R_1051 
  FOREIGN KEY (STD_HANDBOOKRELEASECNTL_ID) 
  REFERENCES ADRREF.STD_HANDBOOKRELEASECONTROL (ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE
  DROP CONSTRAINT R_1050;


ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE ADD (
  CONSTRAINT R_1050 
  FOREIGN KEY (STD_HANDBOOKRELEASECNTL_ID) 
  REFERENCES ADRREF.STD_HANDBOOKRELEASECONTROL (ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SORTBY_TYPE
  DROP CONSTRAINT RPT_SORTBY_TYPE_PK;

ALTER TABLE ADR.RPT_SORTBY_TYPE ADD (
  CONSTRAINT RPT_SORTBY_TYPE_PK
  PRIMARY KEY
  (RPT_SORTBY_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT RPT_SORTBY_TYPE_ID_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT RPT_SORTBY_TYPE_ID_FK 
  FOREIGN KEY (RPT_SORTBY_TYPE_ID) 
  REFERENCES ADR.RPT_SORTBY_TYPE (RPT_SORTBY_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_FORM_TYPE
  DROP CONSTRAINT RPT_SCHED_REP_RPT_FORM_TYP;


ALTER TABLE ADR.RPT_FORM_TYPE ADD (
  CONSTRAINT RPT_SCHED_REP_RPT_FORM_TYP 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_FORM_TYPE
  DROP CONSTRAINT RPT_FORM_TYPE_ID_PK;

ALTER TABLE ADR.RPT_FORM_TYPE ADD (
  CONSTRAINT RPT_FORM_TYPE_ID_PK
  PRIMARY KEY
  (RPT_FORM_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_WKF_CASE
  DROP CONSTRAINT RPTWKFCASE_WKFCASETYP_FK;


ALTER TABLE ADR.RPT_WKF_CASE ADD (
  CONSTRAINT RPTWKFCASE_WKFCASETYP_FK 
  FOREIGN KEY (WKF_CASE_TYPE_ID) 
  REFERENCES ADRREF.STD_WORKFLOWCASETYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_WKF_CASE
  DROP CONSTRAINT RPTWKFCASE_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_WKF_CASE ADD (
  CONSTRAINT RPTWKFCASE_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_WKF_CASE
  DROP CONSTRAINT RPTWKFCASE_PK;

ALTER TABLE ADR.RPT_WKF_CASE ADD (
  CONSTRAINT RPTWKFCASE_PK
  PRIMARY KEY
  (RPT_WKF_CASE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_VBA_QUERY_STATUS
  DROP CONSTRAINT RPTVBAQRY_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_VBA_QUERY_STATUS ADD (
  CONSTRAINT RPTVBAQRY_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_VBA_QUERY_STATUS
  DROP CONSTRAINT RPTVBAQRY_PK;

ALTER TABLE ADR.RPT_VBA_QUERY_STATUS ADD (
  CONSTRAINT RPTVBAQRY_PK
  PRIMARY KEY
  (RPT_VBA_QUERY_STATUS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_USER_GROUP
  DROP CONSTRAINT RPTUSRGRP_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_USER_GROUP ADD (
  CONSTRAINT RPTUSRGRP_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_USER_GROUP
  DROP CONSTRAINT RPTUSRGRP_PK;

ALTER TABLE ADR.RPT_USER_GROUP ADD (
  CONSTRAINT RPTUSRGRP_PK
  PRIMARY KEY
  (RPT_USER_GROUP_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_USERS
  DROP CONSTRAINT RPTUSERS_USER_1_FK;


ALTER TABLE ADR.RPT_USERS ADD (
  CONSTRAINT RPTUSERS_USER_1_FK 
  FOREIGN KEY (USERID) 
  REFERENCES ADR.USERS (USERID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_USERS
  DROP CONSTRAINT RPTUSERS_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_USERS ADD (
  CONSTRAINT RPTUSERS_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_USERS
  DROP CONSTRAINT RPTUSERS_PK;

ALTER TABLE ADR.RPT_USERS ADD (
  CONSTRAINT RPTUSERS_PK
  PRIMARY KEY
  (RPT_USER_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_STATUS_COMPONENT
  DROP CONSTRAINT RPTSTATCMP_STDRPTSTCM_FK;


ALTER TABLE ADR.RPT_STATUS_COMPONENT ADD (
  CONSTRAINT RPTSTATCMP_STDRPTSTCM_FK 
  FOREIGN KEY (STD_RPTSTATUSCOMPONENT_ID) 
  REFERENCES ADRREF.STD_RPTSTATUSCOMPONENT (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_STATUS_COMPONENT
  DROP CONSTRAINT RPTSTATCMP_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_STATUS_COMPONENT ADD (
  CONSTRAINT RPTSTATCMP_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_STATUS_COMPONENT
  DROP CONSTRAINT RPTSTATCMP_PK;

ALTER TABLE ADR.RPT_STATUS_COMPONENT ADD (
  CONSTRAINT RPTSTATCMP_PK
  PRIMARY KEY
  (RPT_STATUS_COMPONENT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SITE
  DROP CONSTRAINT RPTSITE_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_SITE ADD (
  CONSTRAINT RPTSITE_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SITE
  DROP CONSTRAINT RPTSITE_PK;

ALTER TABLE ADR.RPT_SITE ADD (
  CONSTRAINT RPTSITE_PK
  PRIMARY KEY
  (RPT_SITE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_REGISTRY
  DROP CONSTRAINT RPTRGSTRY_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_REGISTRY ADD (
  CONSTRAINT RPTRGSTRY_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_REGISTRY
  DROP CONSTRAINT RPTRGSTRY_PK;

ALTER TABLE ADR.RPT_REGISTRY ADD (
  CONSTRAINT RPTRGSTRY_PK
  PRIMARY KEY
  (RPT_REGISTRY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_QUERY_SITE
  DROP CONSTRAINT RPTQRYSITE_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_QUERY_SITE ADD (
  CONSTRAINT RPTQRYSITE_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_QUERY_SITE
  DROP CONSTRAINT RPTQRYSITE_PK;

ALTER TABLE ADR.RPT_QUERY_SITE ADD (
  CONSTRAINT RPTQRYSITE_PK
  PRIMARY KEY
  (REPORT_QUERY_SITE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS
  DROP CONSTRAINT RPTPRSNMRG_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS ADD (
  CONSTRAINT RPTPRSNMRG_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS
  DROP CONSTRAINT RPTPRSNMRG_PK;

ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS ADD (
  CONSTRAINT RPTPRSNMRG_PK
  PRIMARY KEY
  (RPT_PERSON_MERGE_STATUS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_PRIORITY_GROUP
  DROP CONSTRAINT RPTPRIOGRP_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_PRIORITY_GROUP ADD (
  CONSTRAINT RPTPRIOGRP_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_PRIORITY_GROUP
  DROP CONSTRAINT RPTPRIOGRP_PK;

ALTER TABLE ADR.RPT_PRIORITY_GROUP ADD (
  CONSTRAINT RPTPRIOGRP_PK
  PRIMARY KEY
  (RPT_PRIORITY_GROUP_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_PH_REJECT_REASON
  DROP CONSTRAINT RPTPHRJCT_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_PH_REJECT_REASON ADD (
  CONSTRAINT RPTPHRJCT_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_PH_REJECT_REASON
  DROP CONSTRAINT RPTPHRJCT_PK;

ALTER TABLE ADR.RPT_PH_REJECT_REASON ADD (
  CONSTRAINT RPTPHRJCT_PK
  PRIMARY KEY
  (RPT_PH_REJECT_REASON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_PERMISSIONS
  DROP CONSTRAINT RPTPERM_STD_RPTTYPE_FK;


ALTER TABLE ADR.RPT_PERMISSIONS ADD (
  CONSTRAINT RPTPERM_STD_RPTTYPE_FK 
  FOREIGN KEY (RPT_TYPE_ID) 
  REFERENCES ADRREF.STD_REPORTTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_PERMISSIONS
  DROP CONSTRAINT RPTPERM_STD_PERM_FK;


ALTER TABLE ADR.RPT_PERMISSIONS ADD (
  CONSTRAINT RPTPERM_STD_PERM_FK 
  FOREIGN KEY (PERMISSION_TYPE_ID) 
  REFERENCES ADRREF.STD_PERMISSIONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_PERMISSIONS
  DROP CONSTRAINT RPTPERM_PK;

ALTER TABLE ADR.RPT_PERMISSIONS ADD (
  CONSTRAINT RPTPERM_PK
  PRIMARY KEY
  (RPT_PERMISSION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_MESSAGE
  DROP CONSTRAINT RPTMSG_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_MESSAGE ADD (
  CONSTRAINT RPTMSG_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_MESSAGE
  DROP CONSTRAINT RPTMSG_PK;

ALTER TABLE ADR.RPT_MESSAGE ADD (
  CONSTRAINT RPTMSG_PK
  PRIMARY KEY
  (RPT_MESSAGE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_MESSAGE_ERROR
  DROP CONSTRAINT RPTMSGERR_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_MESSAGE_ERROR ADD (
  CONSTRAINT RPTMSGERR_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_MESSAGE_ERROR
  DROP CONSTRAINT RPTMSGERR_PK;

ALTER TABLE ADR.RPT_MESSAGE_ERROR ADD (
  CONSTRAINT RPTMSGERR_PK
  PRIMARY KEY
  (RPT_MESSAGE_ERROR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_LETTER_FILE
  DROP CONSTRAINT RPTLTRFLTP_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_LETTER_FILE ADD (
  CONSTRAINT RPTLTRFLTP_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_LETTER_FILE
  DROP CONSTRAINT RPTLTRFLTP_RPTLTRFILE_FK;


ALTER TABLE ADR.RPT_LETTER_FILE ADD (
  CONSTRAINT RPTLTRFLTP_RPTLTRFILE_FK 
  FOREIGN KEY (RPT_LETTER_FILE_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTLETTERFILETYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_LETTER_FILE
  DROP CONSTRAINT RPTLTRFLTP_PK;

ALTER TABLE ADR.RPT_LETTER_FILE ADD (
  CONSTRAINT RPTLTRFLTP_PK
  PRIMARY KEY
  (RPT_LETTER_FILE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON
  DROP CONSTRAINT RPTINVADDR_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON ADD (
  CONSTRAINT RPTINVADDR_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON
  DROP CONSTRAINT RPTINVADDR_PK;

ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON ADD (
  CONSTRAINT RPTINVADDR_PK
  PRIMARY KEY
  (RPT_INVALID_ADDRESS_REASON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_EED_WEEKLY
  DROP CONSTRAINT RPTEWK_STD_EEDWKLYTYP_FK;


ALTER TABLE ADR.RPT_EED_WEEKLY ADD (
  CONSTRAINT RPTEWK_STD_EEDWKLYTYP_FK 
  FOREIGN KEY (RPT_EED_WEEKLY_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTEEDWEEKLYTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_EED_WEEKLY
  DROP CONSTRAINT RPTEWK_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_EED_WEEKLY ADD (
  CONSTRAINT RPTEWK_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_ENROLLMENT_STATUS
  DROP CONSTRAINT RPTENRSTAT_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_ENROLLMENT_STATUS ADD (
  CONSTRAINT RPTENRSTAT_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_ENROLLMENT_STATUS
  DROP CONSTRAINT RPTENRSTAT_PK;

ALTER TABLE ADR.RPT_ENROLLMENT_STATUS ADD (
  CONSTRAINT RPTENRSTAT_PK
  PRIMARY KEY
  (RPT_ENROLLMENT_STATUS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE
  DROP CONSTRAINT RPTENROVER_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE ADD (
  CONSTRAINT RPTENROVER_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE
  DROP CONSTRAINT RPTENROVER_PK;

ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE ADD (
  CONSTRAINT RPTENROVER_PK
  PRIMARY KEY
  (RPT_ENROLLMENT_OVERRIDE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY
  DROP CONSTRAINT RPTENRLCAT_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY ADD (
  CONSTRAINT RPTENRLCAT_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY
  DROP CONSTRAINT RPTENRLCAT_PK;

ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY ADD (
  CONSTRAINT RPTENRLCAT_PK
  PRIMARY KEY
  (RPT_ENROLLMENT_CATEGORY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR
  DROP CONSTRAINT RPTELGFCTR_STDRPTELGF_FK;


ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR ADD (
  CONSTRAINT RPTELGFCTR_STDRPTELGF_FK 
  FOREIGN KEY (STD_REPORTELIGFACTOR_ID) 
  REFERENCES ADRREF.STD_REPORTELIGFACTOR (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR
  DROP CONSTRAINT RPTELGFCTR_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR ADD (
  CONSTRAINT RPTELGFCTR_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR
  DROP CONSTRAINT RPTELGFCTR_PK;

ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR ADD (
  CONSTRAINT RPTELGFCTR_PK
  PRIMARY KEY
  (RPT_ELIGIBILITY_FACTOR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_EED_WEEKLY
  DROP CONSTRAINT RPTEEDWKLY_PK;

ALTER TABLE ADR.RPT_EED_WEEKLY ADD (
  CONSTRAINT RPTEEDWKLY_PK
  PRIMARY KEY
  (RPT_EED_WEEKLY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_DAY_OF_WEEK
  DROP CONSTRAINT RPTDOWK_STD_RPTDYWKTYP_FK;


ALTER TABLE ADR.RPT_DAY_OF_WEEK ADD (
  CONSTRAINT RPTDOWK_STD_RPTDYWKTYP_FK 
  FOREIGN KEY (RPT_DAY_OF_WEEK_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDAYOFWEEKTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_DAY_OF_WEEK
  DROP CONSTRAINT RPTDAYOFWK_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_DAY_OF_WEEK ADD (
  CONSTRAINT RPTDAYOFWK_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_DAY_OF_WEEK
  DROP CONSTRAINT RPTDAYOFWK_PK;

ALTER TABLE ADR.RPT_DAY_OF_WEEK ADD (
  CONSTRAINT RPTDAYOFWK_PK
  PRIMARY KEY
  (RPT_DAY_OF_WEEK_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_COM_REJECT_REASON
  DROP CONSTRAINT RPTCOMRJCT_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_COM_REJECT_REASON ADD (
  CONSTRAINT RPTCOMRJCT_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_COM_REJECT_REASON
  DROP CONSTRAINT RPTCOMRJCT_PK;

ALTER TABLE ADR.RPT_COM_REJECT_REASON ADD (
  CONSTRAINT RPTCOMRJCT_PK
  PRIMARY KEY
  (RPT_COM_REJECT_REASON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_COM_REJECT_REASON
  DROP CONSTRAINT RPTCOMRJCT_COMAACRJCT_FK;


ALTER TABLE ADR.RPT_COM_REJECT_REASON ADD (
  CONSTRAINT RPTCOMRJCT_COMAACRJCT_FK 
  FOREIGN KEY (COM_AAC_REJECT_REASON_TYPE_ID) 
  REFERENCES ADRREF.STD_COMREJECTREASONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_COM_ERROR
  DROP CONSTRAINT RPTCOMERR_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_COM_ERROR ADD (
  CONSTRAINT RPTCOMERR_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_COM_ERROR
  DROP CONSTRAINT RPTCOMERR_PK;

ALTER TABLE ADR.RPT_COM_ERROR ADD (
  CONSTRAINT RPTCOMERR_PK
  PRIMARY KEY
  (RPT_COM_ERROR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_COM_ERROR
  DROP CONSTRAINT RPTCOMERR_COMERRTYP_FK;


ALTER TABLE ADR.RPT_COM_ERROR ADD (
  CONSTRAINT RPTCOMERR_COMERRTYP_FK 
  FOREIGN KEY (COM_AAC_ERROR_TYPE_ID) 
  REFERENCES ADRREF.STD_COMMERRORTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON
  DROP CONSTRAINT RPTCANDECL_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON ADD (
  CONSTRAINT RPTCANDECL_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON
  DROP CONSTRAINT RPTCANDECL_PK;

ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON ADD (
  CONSTRAINT RPTCANDECL_PK
  PRIMARY KEY
  (RPT_CANCEL_DECLINE_REASON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLES
  DROP CONSTRAINT ROLE_U_CODE_UK;

ALTER TABLE ADR.ROLES ADD (
  CONSTRAINT ROLE_U_CODE_UK
  UNIQUE (ROLE_NAME)
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLES
  DROP CONSTRAINT ROLE_PK;

ALTER TABLE ADR.ROLES ADD (
  CONSTRAINT ROLE_PK
  PRIMARY KEY
  (ROLE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLES_H
  DROP CONSTRAINT ROLESH_PK;

ALTER TABLE ADR.ROLES_H ADD (
  CONSTRAINT ROLESH_PK
  PRIMARY KEY
  (ROLES_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLE_PERMISSION_SETS_H
  DROP CONSTRAINT ROLEPRMSTH_PK;

ALTER TABLE ADR.ROLE_PERMISSION_SETS_H ADD (
  CONSTRAINT ROLEPRMSTH_PK
  PRIMARY KEY
  (ROLE_PERMISSION_SET_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLE_PERMISSIONS_H
  DROP CONSTRAINT ROLEPRMSH_PK;

ALTER TABLE ADR.ROLE_PERMISSIONS_H ADD (
  CONSTRAINT ROLEPRMSH_PK
  PRIMARY KEY
  (ROLE_PERMISSIONS_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLE_PERMISSIONS
  DROP CONSTRAINT ROLEPERMS_STD_PERM_FK;


ALTER TABLE ADR.ROLE_PERMISSIONS ADD (
  CONSTRAINT ROLEPERMS_STD_PERM_FK 
  FOREIGN KEY (PERMISSION_TYPE_ID) 
  REFERENCES ADRREF.STD_PERMISSIONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLE_PERMISSIONS
  DROP CONSTRAINT ROLEPERMS_ROLE_FK;


ALTER TABLE ADR.ROLE_PERMISSIONS ADD (
  CONSTRAINT ROLEPERMS_ROLE_FK 
  FOREIGN KEY (ROLE_ID) 
  REFERENCES ADR.ROLES (ROLE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLE_PERMISSIONS
  DROP CONSTRAINT ROLEPERMS_PK;

ALTER TABLE ADR.ROLE_PERMISSIONS ADD (
  CONSTRAINT ROLEPERMS_PK
  PRIMARY KEY
  (ROLE_PERMISSION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLE_PERMISSION_SETS
  DROP CONSTRAINT ROLEPERMST_ROLE_FK;


ALTER TABLE ADR.ROLE_PERMISSION_SETS ADD (
  CONSTRAINT ROLEPERMST_ROLE_FK 
  FOREIGN KEY (ROLE_ID) 
  REFERENCES ADR.ROLES (ROLE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLE_PERMISSION_SETS
  DROP CONSTRAINT ROLEPERMST_PK;

ALTER TABLE ADR.ROLE_PERMISSION_SETS ADD (
  CONSTRAINT ROLEPERMST_PK
  PRIMARY KEY
  (ROLE_PERMISSION_SET_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLE_PERMISSION_SETS
  DROP CONSTRAINT ROLEPERMST_PERMSET_FK;


ALTER TABLE ADR.ROLE_PERMISSION_SETS ADD (
  CONSTRAINT ROLEPERMST_PERMSET_FK 
  FOREIGN KEY (PERMISSION_SET_ID) 
  REFERENCES ADR.PERMISSION_SET (PERMISSION_SET_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RELAXATION_PERCENTAGE
  DROP CONSTRAINT RLXPCT_PK;

ALTER TABLE ADR.RELAXATION_PERCENTAGE ADD (
  CONSTRAINT RLXPCT_PK
  PRIMARY KEY
  (RELAXATION_PERCENTAGE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RELAXATION_PERCENTAGE_H
  DROP CONSTRAINT RLXPCTH_PK;

ALTER TABLE ADR.RELAXATION_PERCENTAGE_H ADD (
  CONSTRAINT RLXPCTH_PK
  PRIMARY KEY
  (RELAXATION_PERCENTAGE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.REGISTRY_LOAD_STATISTICS
  DROP CONSTRAINT RGSTRYSTAT_PK;

ALTER TABLE ADR.REGISTRY_LOAD_STATISTICS ADD (
  CONSTRAINT RGSTRYSTAT_PK
  PRIMARY KEY
  (REGISTRY_LOAD_STATISTICS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION
  DROP CONSTRAINT RGSTRLODX_STD_RPTEXCPT_FK;


ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION ADD (
  CONSTRAINT RGSTRLODX_STD_RPTEXCPT_FK 
  FOREIGN KEY (RPT_EXCEPTION_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTEXCEPTIONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION
  DROP CONSTRAINT RGSTRLODX_RGSTRYSTAT_FK;


ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION ADD (
  CONSTRAINT RGSTRLODX_RGSTRYSTAT_FK 
  FOREIGN KEY (REGISTRY_LOAD_STATISTICS_ID) 
  REFERENCES ADR.REGISTRY_LOAD_STATISTICS (REGISTRY_LOAD_STATISTICS_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION
  DROP CONSTRAINT RGSTRLODX_PK;

ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION ADD (
  CONSTRAINT RGSTRLODX_PK
  PRIMARY KEY
  (REGISTRY_LOAD_EXCEPTION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN
  DROP CONSTRAINT RELATIONSHIP69;


ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN ADD (
  CONSTRAINT RELATIONSHIP69 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ON DELETE SET NULL
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT
  DROP CONSTRAINT RELATIONSHIP65;


ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT ADD (
  CONSTRAINT RELATIONSHIP65 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY
  DROP CONSTRAINT RELATIONSHIP60;


ALTER TABLE ADR.PREFERRED_FACILITY ADD (
  CONSTRAINT RELATIONSHIP60 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT
  DROP CONSTRAINT RELATIONSHIP59;


ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT ADD (
  CONSTRAINT RELATIONSHIP59 
  FOREIGN KEY (HEALTH_CARE_PROVIDER_ID) 
  REFERENCES ADR.HEALTH_CARE_PROVIDER (HEALTH_CARE_PROVIDER_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PENSION
  DROP CONSTRAINT RELATIONSHIP55;


ALTER TABLE ADR.PENSION ADD (
  CONSTRAINT RELATIONSHIP55 
  FOREIGN KEY (PENSION_AWARD_TERMINATION_ID4) 
  REFERENCES ADR.PENSION_REASON (PENSION_REASON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PENSION
  DROP CONSTRAINT RELATIONSHIP54;


ALTER TABLE ADR.PENSION ADD (
  CONSTRAINT RELATIONSHIP54 
  FOREIGN KEY (PENSION_AWARD_TERMINATION_ID3) 
  REFERENCES ADR.PENSION_REASON (PENSION_REASON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PENSION
  DROP CONSTRAINT RELATIONSHIP53;


ALTER TABLE ADR.PENSION ADD (
  CONSTRAINT RELATIONSHIP53 
  FOREIGN KEY (PENSION_AWARD_TERMINATION_ID2) 
  REFERENCES ADR.PENSION_REASON (PENSION_REASON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PENSION
  DROP CONSTRAINT RELATIONSHIP52;


ALTER TABLE ADR.PENSION ADD (
  CONSTRAINT RELATIONSHIP52 
  FOREIGN KEY (PENSION_AWARD_TERMINATION_ID1) 
  REFERENCES ADR.PENSION_REASON (PENSION_REASON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PENSION
  DROP CONSTRAINT RELATIONSHIP51;


ALTER TABLE ADR.PENSION ADD (
  CONSTRAINT RELATIONSHIP51 
  FOREIGN KEY (PENSION_AWARD_REASON_ID) 
  REFERENCES ADR.PENSION_REASON (PENSION_REASON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ACTIVATION
  DROP CONSTRAINT RELATIONSHIP43;


ALTER TABLE ADR.ACTIVATION ADD (
  CONSTRAINT RELATIONSHIP43 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SEEDING
  DROP CONSTRAINT RELATIONSHIP39;


ALTER TABLE ADR.SEEDING ADD (
  CONSTRAINT RELATIONSHIP39 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MEDAL_OF_HONOR
  DROP CONSTRAINT RELATIONSHIP25;


ALTER TABLE ADR.MEDAL_OF_HONOR ADD (
  CONSTRAINT RELATIONSHIP25 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT
  DROP CONSTRAINT REGTRAIT_PK;

ALTER TABLE ADR.REGISTRY_TRAIT ADD (
  CONSTRAINT REGTRAIT_PK
  PRIMARY KEY
  (REGISTRY_TRAIT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT_H
  DROP CONSTRAINT REGTRAITH_PK;

ALTER TABLE ADR.REGISTRY_TRAIT_H ADD (
  CONSTRAINT REGTRAITH_PK
  PRIMARY KEY
  (REGISTRY_TRAIT_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL
  DROP CONSTRAINT REGTRAITDT_REGTRAIT_FK;


ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL ADD (
  CONSTRAINT REGTRAITDT_REGTRAIT_FK 
  FOREIGN KEY (REGISTRY_TRAIT_ID) 
  REFERENCES ADR.REGISTRY_TRAIT (REGISTRY_TRAIT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL
  DROP CONSTRAINT REGTRAITDT_PK;

ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL ADD (
  CONSTRAINT REGTRAITDT_PK
  PRIMARY KEY
  (REGISTRY_TRAIT_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL_H
  DROP CONSTRAINT REGTRAIDTH_PK;

ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL_H ADD (
  CONSTRAINT REGTRAIDTH_PK
  PRIMARY KEY
  (REGISTRY_TRAIT_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG
  DROP CONSTRAINT RCVDSRVLOG_SRVLOGID_FK;


ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG ADD (
  CONSTRAINT RCVDSRVLOG_SRVLOGID_FK 
  FOREIGN KEY (CCN_SERVICE_LOG_ID) 
  REFERENCES ADR.CCN_SERVICE_LOG (CCN_SERVICE_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H
  DROP CONSTRAINT RATEDISDTH_PK;

ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H ADD (
  CONSTRAINT RATEDISDTH_PK
  PRIMARY KEY
  (RATED_DISABILITY_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RATED_DISABILITY_DETAIL
  DROP CONSTRAINT RATEDISDET_SVCCON_FK;


ALTER TABLE ADR.RATED_DISABILITY_DETAIL ADD (
  CONSTRAINT RATEDISDET_SVCCON_FK 
  FOREIGN KEY (SERVICE_CONNECTED_ID) 
  REFERENCES ADR.SERVICE_CONNECTED (SERVICE_CONNECTED_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RATED_DISABILITY_DETAIL
  DROP CONSTRAINT RATEDISDET_PK;

ALTER TABLE ADR.RATED_DISABILITY_DETAIL ADD (
  CONSTRAINT RATEDISDET_PK
  PRIMARY KEY
  (RATED_DISABILITY_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.TITLE_38_CARE
  DROP CONSTRAINT QUALIFY_IND_C;

ALTER TABLE ADR.TITLE_38_CARE ADD (
  CONSTRAINT QUALIFY_IND_C
  CHECK (qualify_ind IN ('Y', 'N'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.QRTZ_TRIGGERS
  DROP CONSTRAINT QRTZ_TRIGGER_TO_JOBS_FK;


ALTER TABLE ADR.QRTZ_TRIGGERS ADD (
  CONSTRAINT QRTZ_TRIGGER_TO_JOBS_FK 
  FOREIGN KEY (SCHED_NAME, JOB_NAME, JOB_GROUP) 
  REFERENCES ADR.QRTZ_JOB_DETAILS (SCHED_NAME,JOB_NAME,JOB_GROUP)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_TRIGGERS
  DROP CONSTRAINT QRTZ_TRIGGERS_PK;

ALTER TABLE ADR.QRTZ_TRIGGERS ADD (
  CONSTRAINT QRTZ_TRIGGERS_PK
  PRIMARY KEY
  (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_SIMPROP_TRIGGERS
  DROP CONSTRAINT QRTZ_SIMPROP_TRIG_TO_TRIG_FK;


ALTER TABLE ADR.QRTZ_SIMPROP_TRIGGERS ADD (
  CONSTRAINT QRTZ_SIMPROP_TRIG_TO_TRIG_FK 
  FOREIGN KEY (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP) 
  REFERENCES ADR.QRTZ_TRIGGERS (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_SIMPROP_TRIGGERS
  DROP CONSTRAINT QRTZ_SIMPROP_TRIG_PK;

ALTER TABLE ADR.QRTZ_SIMPROP_TRIGGERS ADD (
  CONSTRAINT QRTZ_SIMPROP_TRIG_PK
  PRIMARY KEY
  (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_SIMPLE_TRIGGERS
  DROP CONSTRAINT QRTZ_SIMPLE_TRIG_TO_TRIG_FK;


ALTER TABLE ADR.QRTZ_SIMPLE_TRIGGERS ADD (
  CONSTRAINT QRTZ_SIMPLE_TRIG_TO_TRIG_FK 
  FOREIGN KEY (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP) 
  REFERENCES ADR.QRTZ_TRIGGERS (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_SIMPLE_TRIGGERS
  DROP CONSTRAINT QRTZ_SIMPLE_TRIG_PK;

ALTER TABLE ADR.QRTZ_SIMPLE_TRIGGERS ADD (
  CONSTRAINT QRTZ_SIMPLE_TRIG_PK
  PRIMARY KEY
  (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_SCHEDULER_STATE
  DROP CONSTRAINT QRTZ_SCHEDULER_STATE_PK;

ALTER TABLE ADR.QRTZ_SCHEDULER_STATE ADD (
  CONSTRAINT QRTZ_SCHEDULER_STATE_PK
  PRIMARY KEY
  (SCHED_NAME, INSTANCE_NAME)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_PAUSED_TRIGGER_GRPS
  DROP CONSTRAINT QRTZ_PAUSED_TRIG_GRPS_PK;

ALTER TABLE ADR.QRTZ_PAUSED_TRIGGER_GRPS ADD (
  CONSTRAINT QRTZ_PAUSED_TRIG_GRPS_PK
  PRIMARY KEY
  (SCHED_NAME, TRIGGER_GROUP)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_LOCKS
  DROP CONSTRAINT QRTZ_LOCKS_PK;

ALTER TABLE ADR.QRTZ_LOCKS ADD (
  CONSTRAINT QRTZ_LOCKS_PK
  PRIMARY KEY
  (SCHED_NAME, LOCK_NAME)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_JOB_DETAILS
  DROP CONSTRAINT QRTZ_JOB_DETAILS_PK;

ALTER TABLE ADR.QRTZ_JOB_DETAILS ADD (
  CONSTRAINT QRTZ_JOB_DETAILS_PK
  PRIMARY KEY
  (SCHED_NAME, JOB_NAME, JOB_GROUP)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_FIRED_TRIGGERS
  DROP CONSTRAINT QRTZ_FIRED_TRIGGER_PK;

ALTER TABLE ADR.QRTZ_FIRED_TRIGGERS ADD (
  CONSTRAINT QRTZ_FIRED_TRIGGER_PK
  PRIMARY KEY
  (SCHED_NAME, ENTRY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_CRON_TRIGGERS
  DROP CONSTRAINT QRTZ_CRON_TRIG_TO_TRIG_FK;


ALTER TABLE ADR.QRTZ_CRON_TRIGGERS ADD (
  CONSTRAINT QRTZ_CRON_TRIG_TO_TRIG_FK 
  FOREIGN KEY (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP) 
  REFERENCES ADR.QRTZ_TRIGGERS (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_CRON_TRIGGERS
  DROP CONSTRAINT QRTZ_CRON_TRIG_PK;

ALTER TABLE ADR.QRTZ_CRON_TRIGGERS ADD (
  CONSTRAINT QRTZ_CRON_TRIG_PK
  PRIMARY KEY
  (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_CALENDARS
  DROP CONSTRAINT QRTZ_CALENDARS_PK;

ALTER TABLE ADR.QRTZ_CALENDARS ADD (
  CONSTRAINT QRTZ_CALENDARS_PK
  PRIMARY KEY
  (SCHED_NAME, CALENDAR_NAME)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_BLOB_TRIGGERS
  DROP CONSTRAINT QRTZ_BLOB_TRIG_TO_TRIG_FK;


ALTER TABLE ADR.QRTZ_BLOB_TRIGGERS ADD (
  CONSTRAINT QRTZ_BLOB_TRIG_TO_TRIG_FK 
  FOREIGN KEY (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP) 
  REFERENCES ADR.QRTZ_TRIGGERS (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_BLOB_TRIGGERS
  DROP CONSTRAINT QRTZ_BLOB_TRIG_PK;

ALTER TABLE ADR.QRTZ_BLOB_TRIGGERS ADD (
  CONSTRAINT QRTZ_BLOB_TRIG_PK
  PRIMARY KEY
  (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
  ENABLE VALIDATE);
ALTER TABLE ADR.PURPOSE_OF_USE_TYPE
  DROP CONSTRAINT PURPOSE_OF_USE_TYPE_PK;

ALTER TABLE ADR.PURPOSE_OF_USE_TYPE ADD (
  CONSTRAINT PURPOSE_OF_USE_TYPE_PK
  PRIMARY KEY
  (PURPOSE_OF_USE_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT PURPOSE_OF_USE_FK;


ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT PURPOSE_OF_USE_FK 
  FOREIGN KEY (PURPOSE_OF_USE_TYPE_ID) 
  REFERENCES ADR.PURPOSE_OF_USE_TYPE (PURPOSE_OF_USE_TYPE_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS
  DROP CONSTRAINT PSETPRM_STD_PERM_FK;


ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS ADD (
  CONSTRAINT PSETPRM_STD_PERM_FK 
  FOREIGN KEY (PERMISSION_TYPE_ID) 
  REFERENCES ADRREF.STD_PERMISSIONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS
  DROP CONSTRAINT PSETPRM_PERMSET_FK;


ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS ADD (
  CONSTRAINT PSETPRM_PERMSET_FK 
  FOREIGN KEY (PERMISSION_SET_ID) 
  REFERENCES ADR.PERMISSION_SET (PERMISSION_SET_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON
  DROP CONSTRAINT PRSN_VPIDVALUE_UK;

ALTER TABLE ADR.PERSON ADD (
  CONSTRAINT PRSN_VPIDVALUE_UK
  UNIQUE (VPID_VALUE)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON
  DROP CONSTRAINT PRSN_U_VPID_UK;

ALTER TABLE ADR.PERSON ADD (
  CONSTRAINT PRSN_U_VPID_UK
  UNIQUE (VPID_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_TRAITS
  DROP CONSTRAINT PRSN_U_VPIDVAL_UN;

ALTER TABLE ADR.PERSON_TRAITS ADD (
  CONSTRAINT PRSN_U_VPIDVAL_UN
  UNIQUE (VPID_VALUE)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON
  DROP CONSTRAINT PRSN_PK;

ALTER TABLE ADR.PERSON ADD (
  CONSTRAINT PRSN_PK
  PRIMARY KEY
  (PERSON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_UNMERGE
  DROP CONSTRAINT PRSNUNMRG_PK;

ALTER TABLE ADR.PERSON_UNMERGE ADD (
  CONSTRAINT PRSNUNMRG_PK
  PRIMARY KEY
  (PERSON_UNMERGE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_RELATION
  DROP CONSTRAINT PRSNREL_PRSN_FK;


ALTER TABLE ADR.PERSON_RELATION ADD (
  CONSTRAINT PRSNREL_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_RELATION
  DROP CONSTRAINT PRSNREL_PK;

ALTER TABLE ADR.PERSON_RELATION ADD (
  CONSTRAINT PRSNREL_PK
  PRIMARY KEY
  (PERSON_RELATION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_RELATION_UNMERGE
  DROP CONSTRAINT PRSNRELUNM_PK;

ALTER TABLE ADR.PERSON_RELATION_UNMERGE ADD (
  CONSTRAINT PRSNRELUNM_PK
  PRIMARY KEY
  (PERSON_RELATION_UNMERGE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_RELATION_MERGE
  DROP CONSTRAINT PRSNRELMRG_PRSN_FK;


ALTER TABLE ADR.PERSON_RELATION_MERGE ADD (
  CONSTRAINT PRSNRELMRG_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_RELATION_MERGE
  DROP CONSTRAINT PRSNRELMRG_PK;

ALTER TABLE ADR.PERSON_RELATION_MERGE ADD (
  CONSTRAINT PRSNRELMRG_PK
  PRIMARY KEY
  (PERSON_RELATION_MERGE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_RELATION_H
  DROP CONSTRAINT PRSNRELH_PK;

ALTER TABLE ADR.PERSON_RELATION_H ADD (
  CONSTRAINT PRSNRELH_PK
  PRIMARY KEY
  (PERSON_RELATION_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_RACE
  DROP CONSTRAINT PRSNRACE_PRSN_FK;


ALTER TABLE ADR.PERSON_RACE ADD (
  CONSTRAINT PRSNRACE_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_RACE
  DROP CONSTRAINT PRSNRACE_PK;

ALTER TABLE ADR.PERSON_RACE ADD (
  CONSTRAINT PRSNRACE_PK
  PRIMARY KEY
  (PERSON_RACE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_RACE_H
  DROP CONSTRAINT PRSNRACEH_PK;

ALTER TABLE ADR.PERSON_RACE_H ADD (
  CONSTRAINT PRSNRACEH_PK
  PRIMARY KEY
  (PERSON_RACE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE
  DROP CONSTRAINT PRSNPRSNPREFLANG_FK;


ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE ADD (
  CONSTRAINT PRSNPRSNPREFLANG_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_MERGE
  DROP CONSTRAINT PRSNMRG_PK;

ALTER TABLE ADR.PERSON_MERGE ADD (
  CONSTRAINT PRSNMRG_PK
  PRIMARY KEY
  (PERSON_MERGE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_H
  DROP CONSTRAINT PRSNH_PK;

ALTER TABLE ADR.PERSON_H ADD (
  CONSTRAINT PRSNH_PK
  PRIMARY KEY
  (PERSON_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_ETHNICITY
  DROP CONSTRAINT PRSNETNCTY_PRSN_FK;


ALTER TABLE ADR.PERSON_ETHNICITY ADD (
  CONSTRAINT PRSNETNCTY_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_ETHNICITY
  DROP CONSTRAINT PRSNETNCTY_PK;

ALTER TABLE ADR.PERSON_ETHNICITY ADD (
  CONSTRAINT PRSNETNCTY_PK
  PRIMARY KEY
  (PERSON_ETHNICITY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_ETHNICITY_H
  DROP CONSTRAINT PRSNETNCTH_PK;

ALTER TABLE ADR.PERSON_ETHNICITY_H ADD (
  CONSTRAINT PRSNETNCTH_PK
  PRIMARY KEY
  (PERSON_ETHNICITY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_CONTACT
  DROP CONSTRAINT PRSNCTAC_PRSN_FK;


ALTER TABLE ADR.PERSON_CONTACT ADD (
  CONSTRAINT PRSNCTAC_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CONTACT
  DROP CONSTRAINT PRSNCTAC_PK;

ALTER TABLE ADR.PERSON_CONTACT ADD (
  CONSTRAINT PRSNCTAC_PK
  PRIMARY KEY
  (PERSON_CONTACT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_CONTACT_H
  DROP CONSTRAINT PRSNCTACH_PK;

ALTER TABLE ADR.PERSON_CONTACT_H ADD (
  CONSTRAINT PRSNCTACH_PK
  PRIMARY KEY
  (PERSON_CONTACT_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_CHANGE_LOG
  DROP CONSTRAINT PRSNCHGLOG_PRSN_FK;


ALTER TABLE ADR.PERSON_CHANGE_LOG ADD (
  CONSTRAINT PRSNCHGLOG_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CHANGE_LOG
  DROP CONSTRAINT PRSNCHGLOG_PK;

ALTER TABLE ADR.PERSON_CHANGE_LOG ADD (
  CONSTRAINT PRSNCHGLOG_PK
  PRIMARY KEY
  (PERSON_CHANGE_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PURPLE_HEART_REGISTRY_H
  DROP CONSTRAINT PRPLHRTREH_PK;

ALTER TABLE ADR.PURPLE_HEART_REGISTRY_H ADD (
  CONSTRAINT PRPLHRTREH_PK
  PRIMARY KEY
  (PURPLE_HEART_REGISTRY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PURPLE_HEART_REGISTRY
  DROP CONSTRAINT PRPLHRTREG_REGTRAIT_FK;


ALTER TABLE ADR.PURPLE_HEART_REGISTRY ADD (
  CONSTRAINT PRPLHRTREG_REGTRAIT_FK 
  FOREIGN KEY (REGISTRY_TRAIT_ID) 
  REFERENCES ADR.REGISTRY_TRAIT (REGISTRY_TRAIT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PURPLE_HEART_REGISTRY
  DROP CONSTRAINT PRPLHRTREG_PRSN_FK;


ALTER TABLE ADR.PURPLE_HEART_REGISTRY ADD (
  CONSTRAINT PRPLHRTREG_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PURPLE_HEART_REGISTRY
  DROP CONSTRAINT PRPLHRTREG_PK;

ALTER TABLE ADR.PURPLE_HEART_REGISTRY ADD (
  CONSTRAINT PRPLHRTREG_PK
  PRIMARY KEY
  (PURPLE_HEART_REGISTRY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS
  DROP CONSTRAINT PRMSTPRM_PK;

ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS ADD (
  CONSTRAINT PRMSTPRM_PK
  PRIMARY KEY
  (PERM_SET_PERMISSIONS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H
  DROP CONSTRAINT PRMSTPRMH_PK;

ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H ADD (
  CONSTRAINT PRMSTPRMH_PK
  PRIMARY KEY
  (PERM_SET_PERMISSIONS_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT PRIOR_ENROLLMENT_CK;

ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT PRIOR_ENROLLMENT_CK
  CHECK (PRIOR_ENROLLMENT IN ('all', 'yes', 'no'))
  ENABLE VALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY
  DROP CONSTRAINT PRFFCL_PK;

ALTER TABLE ADR.PREFERRED_FACILITY ADD (
  CONSTRAINT PRFFCL_PK
  PRIMARY KEY
  (PREFERRED_FACILITY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY_H
  DROP CONSTRAINT PRFFCLH_PK;

ALTER TABLE ADR.PREFERRED_FACILITY_H ADD (
  CONSTRAINT PRFFCLH_PK
  PRIMARY KEY
  (PREFERRED_FACILITY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY
  DROP CONSTRAINT POW_REGTRAIT_FK;


ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY ADD (
  CONSTRAINT POW_REGTRAIT_FK 
  FOREIGN KEY (REGISTRY_TRAIT_ID) 
  REFERENCES ADR.REGISTRY_TRAIT (REGISTRY_TRAIT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY
  DROP CONSTRAINT POW_PRSN_FK;


ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY ADD (
  CONSTRAINT POW_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY
  DROP CONSTRAINT POW_PK;

ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY ADD (
  CONSTRAINT POW_PK
  PRIMARY KEY
  (PRISONER_OF_WAR_REGISTRY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.POW_REGISTRY_DETAIL
  DROP CONSTRAINT POWREGDTL_POW_FK;


ALTER TABLE ADR.POW_REGISTRY_DETAIL ADD (
  CONSTRAINT POWREGDTL_POW_FK 
  FOREIGN KEY (PRISONER_OF_WAR_REGISTRY_ID) 
  REFERENCES ADR.PRISONER_OF_WAR_REGISTRY (PRISONER_OF_WAR_REGISTRY_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.POW_REGISTRY_DETAIL
  DROP CONSTRAINT POWREGDTL_PK;

ALTER TABLE ADR.POW_REGISTRY_DETAIL ADD (
  CONSTRAINT POWREGDTL_PK
  PRIMARY KEY
  (POW_REGISTRY_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.POW_REGISTRY_DETAIL_H
  DROP CONSTRAINT POWREGDTH_PK;

ALTER TABLE ADR.POW_REGISTRY_DETAIL_H ADD (
  CONSTRAINT POWREGDTH_PK
  PRIMARY KEY
  (POW_REGISTRY_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H
  DROP CONSTRAINT POWH_PK;

ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H ADD (
  CONSTRAINT POWH_PK
  PRIMARY KEY
  (PRISONER_OF_WAR_REGISTRY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PENSION
  DROP CONSTRAINT PNS_PK;

ALTER TABLE ADR.PENSION ADD (
  CONSTRAINT PNS_PK
  PRIMARY KEY
  (PENSION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PENSION_REASON
  DROP CONSTRAINT PNSRSN_PK;

ALTER TABLE ADR.PENSION_REASON ADD (
  CONSTRAINT PNSRSN_PK
  PRIMARY KEY
  (PENSION_REASON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PENSION_H
  DROP CONSTRAINT PNSH_PK;

ALTER TABLE ADR.PENSION_H ADD (
  CONSTRAINT PNSH_PK
  PRIMARY KEY
  (PENSION_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PH_REGISTRY_DETAIL
  DROP CONSTRAINT PHREGDTL_PRPLHRTREG_FK;


ALTER TABLE ADR.PH_REGISTRY_DETAIL ADD (
  CONSTRAINT PHREGDTL_PRPLHRTREG_FK 
  FOREIGN KEY (PURPLE_HEART_REGISTRY_ID) 
  REFERENCES ADR.PURPLE_HEART_REGISTRY (PURPLE_HEART_REGISTRY_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.PH_REGISTRY_DETAIL
  DROP CONSTRAINT PHREGDTL_PK;

ALTER TABLE ADR.PH_REGISTRY_DETAIL ADD (
  CONSTRAINT PHREGDTL_PK
  PRIMARY KEY
  (PH_REGISTRY_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PH_REGISTRY_DETAIL_H
  DROP CONSTRAINT PHREGDTLH_PK;

ALTER TABLE ADR.PH_REGISTRY_DETAIL_H ADD (
  CONSTRAINT PHREGDTLH_PK
  PRIMARY KEY
  (PH_REGISTRY_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PHONE
  DROP CONSTRAINT PHONE_PRSN_FK;


ALTER TABLE ADR.PHONE ADD (
  CONSTRAINT PHONE_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PHONE
  DROP CONSTRAINT PHONE_PRSNREL_FK;


ALTER TABLE ADR.PHONE ADD (
  CONSTRAINT PHONE_PRSNREL_FK 
  FOREIGN KEY (PERSON_RELATION_ID) 
  REFERENCES ADR.PERSON_RELATION (PERSON_RELATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.PHONE
  DROP CONSTRAINT PHONE_PK;

ALTER TABLE ADR.PHONE ADD (
  CONSTRAINT PHONE_PK
  PRIMARY KEY
  (PHONE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PHONE
  DROP CONSTRAINT PHONE_INSURANCE_FK;


ALTER TABLE ADR.PHONE ADD (
  CONSTRAINT PHONE_INSURANCE_FK 
  FOREIGN KEY (INSURANCE_ID) 
  REFERENCES ADR.INSURANCE (INSURANCE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PHONE_H
  DROP CONSTRAINT PHONEH_PK;

ALTER TABLE ADR.PHONE_H ADD (
  CONSTRAINT PHONEH_PK
  PRIMARY KEY
  (PHONE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PHONE
  DROP CONSTRAINT PHN_SITE_OF_CNG_FK;


ALTER TABLE ADR.PHONE ADD (
  CONSTRAINT PHN_SITE_OF_CNG_FK 
  FOREIGN KEY (SITE_OF_CHANGE_ID) 
  REFERENCES ADR.LOOKUP_TYPE (LOOKUP_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON
  DROP CONSTRAINT PER_SUPDOCLKUP_TYPE_FK;


ALTER TABLE ADR.PERSON ADD (
  CONSTRAINT PER_SUPDOCLKUP_TYPE_FK 
  FOREIGN KEY (SUP_DOC_LOOKUP_TYPE_ID) 
  REFERENCES ADR.LOOKUP_TYPE (LOOKUP_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE
  DROP CONSTRAINT PERSON_PREFERRED_LANGUAGE_PK;

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE ADD (
  CONSTRAINT PERSON_PREFERRED_LANGUAGE_PK
  PRIMARY KEY
  (PERSON_PREFERRED_LANGUAGE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H
  DROP CONSTRAINT PERSON_PREFERRED_LANGUAGE_H_PK;

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H ADD (
  CONSTRAINT PERSON_PREFERRED_LANGUAGE_H_PK
  PRIMARY KEY
  (PERSON_PREFERRED_LANG_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION
  DROP CONSTRAINT PERSON_ID_UK;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION ADD (
  CONSTRAINT PERSON_ID_UK
  UNIQUE (PERSON_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MEC_PERIOD_LAST_HIST_NEW
  DROP CONSTRAINT PERSON_ID_MAX_PK;

ALTER TABLE ADR.MEC_PERIOD_LAST_HIST_NEW ADD (
  CONSTRAINT PERSON_ID_MAX_PK
  PRIMARY KEY
  (PERSON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MANUAL_OVERRIDE
  DROP CONSTRAINT PERSON_ID_FK;


ALTER TABLE ADR.MANUAL_OVERRIDE ADD (
  CONSTRAINT PERSON_ID_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_TRAITS_BKP
  DROP CONSTRAINT PERSONTRAITSID_PK_I_BKP;

ALTER TABLE ADR.PERSON_TRAITS_BKP ADD (
  CONSTRAINT PERSONTRAITSID_PK_I_BKP
  PRIMARY KEY
  (PERSON_TRAITS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_TRAITS
  DROP CONSTRAINT PERSONTRAITSID_PK_I;

ALTER TABLE ADR.PERSON_TRAITS ADD (
  CONSTRAINT PERSONTRAITSID_PK_I
  PRIMARY KEY
  (PERSON_TRAITS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL
  DROP CONSTRAINT PERSN_IRSTRNSLGDET_PRSN_ID_FK;


ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL ADD (
  CONSTRAINT PERSN_IRSTRNSLGDET_PRSN_ID_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERMISSION_SET
  DROP CONSTRAINT PERMSET_U_CODE_UK;

ALTER TABLE ADR.PERMISSION_SET ADD (
  CONSTRAINT PERMSET_U_CODE_UK
  UNIQUE (NAME)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERMISSION_SET
  DROP CONSTRAINT PERMSET_PK;

ALTER TABLE ADR.PERMISSION_SET ADD (
  CONSTRAINT PERMSET_PK
  PRIMARY KEY
  (PERMISSION_SET_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERMISSION_SET_H
  DROP CONSTRAINT PERMSETH_PK;

ALTER TABLE ADR.PERMISSION_SET_H ADD (
  CONSTRAINT PERMSETH_PK
  PRIMARY KEY
  (PERMISSION_SET_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PCP_STAGE
  DROP CONSTRAINT PCP_STAGE_PK;

ALTER TABLE ADR.PCP_STAGE ADD (
  CONSTRAINT PCP_STAGE_PK
  PRIMARY KEY
  (PCP_STAGE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PCP_STAGE
  DROP CONSTRAINT PCPSTAGE_PERSONID_FK;


ALTER TABLE ADR.PCP_STAGE ADD (
  CONSTRAINT PCPSTAGE_PERSONID_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT
  DROP CONSTRAINT PATPRVASGN_PK;

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT ADD (
  CONSTRAINT PATPRVASGN_PK
  PRIMARY KEY
  (PATIENT_PROVIDER_ASSIGNMENT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H
  DROP CONSTRAINT PATPRVASGNH_PK;

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H ADD (
  CONSTRAINT PATPRVASGNH_PK
  PRIMARY KEY
  (PATIENT_PROVIDER_ASSIGN_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.NARRATIVE_REASON_TYPE
  DROP CONSTRAINT NARRATIVE_REASON_TYPE_PK;

ALTER TABLE ADR.NARRATIVE_REASON_TYPE ADD (
  CONSTRAINT NARRATIVE_REASON_TYPE_PK
  PRIMARY KEY
  (NARRATIVE_REASON_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.TRANSMISSION_TYPE
  DROP CONSTRAINT NAME_UK;

ALTER TABLE ADR.TRANSMISSION_TYPE ADD (
  CONSTRAINT NAME_UK
  UNIQUE (NAME)
  ENABLE VALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE
  DROP CONSTRAINT MSE_PAY_PLAN_TYPE_FK;


ALTER TABLE ADR.MILITARY_SERVICE_EPISODE ADD (
  CONSTRAINT MSE_PAY_PLAN_TYPE_FK 
  FOREIGN KEY (PAY_PLAN_TYPE_ID) 
  REFERENCES ADR.LOOKUP_TYPE (LOOKUP_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE
  DROP CONSTRAINT MSE_NARLKUP_TYPE_FK;


ALTER TABLE ADR.MILITARY_SERVICE_EPISODE ADD (
  CONSTRAINT MSE_NARLKUP_TYPE_FK 
  FOREIGN KEY (NARRATIVE_REASON_TYPE_ID) 
  REFERENCES ADR.NARRATIVE_REASON_TYPE (NARRATIVE_REASON_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL
  DROP CONSTRAINT MONEYBNDTL_PK;

ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL ADD (
  CONSTRAINT MONEYBNDTL_PK
  PRIMARY KEY
  (MONETARY_BENEFIT_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL
  DROP CONSTRAINT MONEYBNDTL_MONEYBEN_FK;


ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL ADD (
  CONSTRAINT MONEYBNDTL_MONEYBEN_FK 
  FOREIGN KEY (MONETARY_BENEFIT_ID) 
  REFERENCES ADR.MONETARY_BENEFIT (MONETARY_BENEFIT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H
  DROP CONSTRAINT MONEYBNDTLH_PK;

ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H ADD (
  CONSTRAINT MONEYBNDTLH_PK
  PRIMARY KEY
  (MONETARY_BENEFIT_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT
  DROP CONSTRAINT MONEYBEN_PRSN_FK;


ALTER TABLE ADR.MONETARY_BENEFIT ADD (
  CONSTRAINT MONEYBEN_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT
  DROP CONSTRAINT MONEYBEN_PK;

ALTER TABLE ADR.MONETARY_BENEFIT ADD (
  CONSTRAINT MONEYBEN_PK
  PRIMARY KEY
  (MONETARY_BENEFIT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_H
  DROP CONSTRAINT MONEYBENH_PK;

ALTER TABLE ADR.MONETARY_BENEFIT_H ADD (
  CONSTRAINT MONEYBENH_PK
  PRIMARY KEY
  (MONETARY_BENEFIT_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MEDAL_OF_HONOR
  DROP CONSTRAINT MOH_PK;

ALTER TABLE ADR.MEDAL_OF_HONOR ADD (
  CONSTRAINT MOH_PK
  PRIMARY KEY
  (MEDAL_OF_HONOR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MEDAL_OF_HONOR_H
  DROP CONSTRAINT MOH_H_PK;

ALTER TABLE ADR.MEDAL_OF_HONOR_H ADD (
  CONSTRAINT MOH_H_PK
  PRIMARY KEY
  (MEDAL_OF_HONOR_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE
  DROP CONSTRAINT MILSRVC_PRSN_FK;


ALTER TABLE ADR.MILITARY_SERVICE ADD (
  CONSTRAINT MILSRVC_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE
  DROP CONSTRAINT MILSRVC_PK;

ALTER TABLE ADR.MILITARY_SERVICE ADD (
  CONSTRAINT MILSRVC_PK
  PRIMARY KEY
  (MILITARY_SERVICE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_H
  DROP CONSTRAINT MILSRVCH_PK;

ALTER TABLE ADR.MILITARY_SERVICE_H ADD (
  CONSTRAINT MILSRVCH_PK
  PRIMARY KEY
  (MILITARY_SERVICE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE
  DROP CONSTRAINT MILSRVCEPS_PK;

ALTER TABLE ADR.MILITARY_SERVICE_EPISODE ADD (
  CONSTRAINT MILSRVCEPS_PK
  PRIMARY KEY
  (MILITARY_SERVICE_EPISODE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE
  DROP CONSTRAINT MILSRVCEPS_MILSRVC_FK;


ALTER TABLE ADR.MILITARY_SERVICE_EPISODE ADD (
  CONSTRAINT MILSRVCEPS_MILSRVC_FK 
  FOREIGN KEY (MILITARY_SERVICE_ID) 
  REFERENCES ADR.MILITARY_SERVICE (MILITARY_SERVICE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H
  DROP CONSTRAINT MILSRVCEPH_PK;

ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H ADD (
  CONSTRAINT MILSRVCEPH_PK
  PRIMARY KEY
  (MILITARY_SERVICE_EPISODE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE
  DROP CONSTRAINT MILITARY_SERVICE_ID_FK;


ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE ADD (
  CONSTRAINT MILITARY_SERVICE_ID_FK 
  FOREIGN KEY (MILITARY_SERVICE_ID) 
  REFERENCES ADR.MILITARY_SERVICE (MILITARY_SERVICE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE
  DROP CONSTRAINT MILITARY_FUTURE_DIS_PK;

ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE ADD (
  CONSTRAINT MILITARY_FUTURE_DIS_PK
  PRIMARY KEY
  (MILITARY_FUTURE_DISCHARGE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE_H
  DROP CONSTRAINT MILITARY_FUTURE_DIS_H_PK;

ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE_H ADD (
  CONSTRAINT MILITARY_FUTURE_DIS_H_PK
  PRIMARY KEY
  (MILITARY_FUTURE_DISCHARGE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MEDICAID_FACTOR
  DROP CONSTRAINT MEDICAID_PRSN_FK;


ALTER TABLE ADR.MEDICAID_FACTOR ADD (
  CONSTRAINT MEDICAID_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MEDICAID_FACTOR
  DROP CONSTRAINT MEDICAID_PK;

ALTER TABLE ADR.MEDICAID_FACTOR ADD (
  CONSTRAINT MEDICAID_PK
  PRIMARY KEY
  (MEDICAID_FACTOR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MEDICAID_FACTOR_H
  DROP CONSTRAINT MEDICAIDH_PK;

ALTER TABLE ADR.MEDICAID_FACTOR_H ADD (
  CONSTRAINT MEDICAIDH_PK
  PRIMARY KEY
  (MEDICAID_FACTOR_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MEC_PERIOD_NEW
  DROP CONSTRAINT MEC_PERIOD_NEW_PERSON_FK;


ALTER TABLE ADR.MEC_PERIOD_NEW ADD (
  CONSTRAINT MEC_PERIOD_NEW_PERSON_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MEC_PERIOD_NEW
  DROP CONSTRAINT MEC_PERIOD_ID_PK;

ALTER TABLE ADR.MEC_PERIOD_NEW ADD (
  CONSTRAINT MEC_PERIOD_ID_PK
  PRIMARY KEY
  (MEC_PERIOD_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MANUAL_OVERRIDE_RSN_TYPE
  DROP CONSTRAINT MANUAL_OVERRIDE_RSN_TYPE_PK;

ALTER TABLE ADR.MANUAL_OVERRIDE_RSN_TYPE ADD (
  CONSTRAINT MANUAL_OVERRIDE_RSN_TYPE_PK
  PRIMARY KEY
  (MANUAL_OVERRIDE_RSN_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MANUAL_OVERRIDE
  DROP CONSTRAINT MANUAL_OVERRIDE_RSN_TYPE_ID_FK;


ALTER TABLE ADR.MANUAL_OVERRIDE ADD (
  CONSTRAINT MANUAL_OVERRIDE_RSN_TYPE_ID_FK 
  FOREIGN KEY (MANUAL_OVERRIDE_RSN_TYPE_ID) 
  REFERENCES ADR.MANUAL_OVERRIDE_RSN_TYPE (MANUAL_OVERRIDE_RSN_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MANUAL_OVERRIDE
  DROP CONSTRAINT MANUAL_OVERRIDE_PK;

ALTER TABLE ADR.MANUAL_OVERRIDE ADD (
  CONSTRAINT MANUAL_OVERRIDE_PK
  PRIMARY KEY
  (MANUAL_OVERRIDE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MANUAL_OVERRIDE_H
  DROP CONSTRAINT MANUAL_OVERRIDE_H_PK;

ALTER TABLE ADR.MANUAL_OVERRIDE_H ADD (
  CONSTRAINT MANUAL_OVERRIDE_H_PK
  PRIMARY KEY
  (MANUAL_OVERRIDE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.LOOKUP_TYPE
  DROP CONSTRAINT LOOKUP_TYPE_PK;

ALTER TABLE ADR.LOOKUP_TYPE ADD (
  CONSTRAINT LOOKUP_TYPE_PK
  PRIMARY KEY
  (LOOKUP_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.LOOKUP_TYPE
  DROP CONSTRAINT LOOKUPTYPE_ISACTIVE_CONS;

ALTER TABLE ADR.LOOKUP_TYPE ADD (
  CONSTRAINT LOOKUPTYPE_ISACTIVE_CONS
  CHECK ( ISACTIVE IN ('0','1'))
  ENABLE VALIDATE);
ALTER TABLE ADR.ACTIVEAGG_TRACKER
  DROP CONSTRAINT LOADING_STATUS_CHK;

ALTER TABLE ADR.ACTIVEAGG_TRACKER ADD (
  CONSTRAINT LOADING_STATUS_CHK
  CHECK (LOADING_STATUS IN ('YES','FAIL'))
  ENABLE VALIDATE);
ALTER TABLE ADR.JOB_RESULT
  DROP CONSTRAINT JRESULT_PK;

ALTER TABLE ADR.JOB_RESULT ADD (
  CONSTRAINT JRESULT_PK
  PRIMARY KEY
  (JOB_RESULT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.JOB_CONFIG
  DROP CONSTRAINT JCONFIG_PK;

ALTER TABLE ADR.JOB_CONFIG ADD (
  CONSTRAINT JCONFIG_PK
  PRIMARY KEY
  (JOB_CONFIG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.IVM_MIGRATE_STATISTICS
  DROP CONSTRAINT IVMMIGSTAT_PK;

ALTER TABLE ADR.IVM_MIGRATE_STATISTICS ADD (
  CONSTRAINT IVMMIGSTAT_PK
  PRIMARY KEY
  (IVM_MIGRATE_STATISTICS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.IVM_MIGRATE
  DROP CONSTRAINT IVMMGRT_PRSN_FK;


ALTER TABLE ADR.IVM_MIGRATE ADD (
  CONSTRAINT IVMMGRT_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.IVM_MIGRATE
  DROP CONSTRAINT IVMMGRT_PK;

ALTER TABLE ADR.IVM_MIGRATE ADD (
  CONSTRAINT IVMMGRT_PK
  PRIMARY KEY
  (IVM_MIGRATE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.IVM_MIGRATE_EXTRACT
  DROP CONSTRAINT IVMMGEX_PK;

ALTER TABLE ADR.IVM_MIGRATE_EXTRACT ADD (
  CONSTRAINT IVMMGEX_PK
  PRIMARY KEY
  (IVM_MIGRATE_EXTRACT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL
  DROP CONSTRAINT IVMMGEXDTL_PK;

ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL ADD (
  CONSTRAINT IVMMGEXDTL_PK
  PRIMARY KEY
  (IVM_MIGRATE_EXTRACT_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL
  DROP CONSTRAINT IVMMGEXDTL_IVMMGEX_FK;


ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL ADD (
  CONSTRAINT IVMMGEXDTL_IVMMGEX_FK 
  FOREIGN KEY (IVM_MIGRATE_EXTRACT_ID) 
  REFERENCES ADR.IVM_MIGRATE_EXTRACT (IVM_MIGRATE_EXTRACT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL
  DROP CONSTRAINT IRS_TRANS_LOG_DET_ID_PK;

ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL ADD (
  CONSTRAINT IRS_TRANS_LOG_DET_ID_PK
  PRIMARY KEY
  (IRS_TRANSMISSION_LOG_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.IRS_TRANSMISSION_LOG
  DROP CONSTRAINT IRS_TRANSMISSION_LOG_ID_PK;

ALTER TABLE ADR.IRS_TRANSMISSION_LOG ADD (
  CONSTRAINT IRS_TRANSMISSION_LOG_ID_PK
  PRIMARY KEY
  (IRS_TRANSMISSION_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.IRS_TRANSMISSION_DATA
  DROP CONSTRAINT IRS_TRANSMISSION_DATA_ID_PK;

ALTER TABLE ADR.IRS_TRANSMISSION_DATA ADD (
  CONSTRAINT IRS_TRANSMISSION_DATA_ID_PK
  PRIMARY KEY
  (IRS_TRANSMISSION_DATA_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL
  DROP CONSTRAINT IRSTRNSLOG_IRSTRNSLGDET_FK;


ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL ADD (
  CONSTRAINT IRSTRNSLOG_IRSTRNSLGDET_FK 
  FOREIGN KEY (IRS_TRANSMISSION_LOG_ID) 
  REFERENCES ADR.IRS_TRANSMISSION_LOG (IRS_TRANSMISSION_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.IRS_TRANSMISSION_DATA
  DROP CONSTRAINT IRSTRNSLOG_IRSTRNSDATA_FK;


ALTER TABLE ADR.IRS_TRANSMISSION_DATA ADD (
  CONSTRAINT IRSTRNSLOG_IRSTRNSDATA_FK 
  FOREIGN KEY (IRS_TRANSMISSION_LOG_ID) 
  REFERENCES ADR.IRS_TRANSMISSION_LOG (IRS_TRANSMISSION_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.INSURANCE
  DROP CONSTRAINT INSURANCE_PRSN_FK;


ALTER TABLE ADR.INSURANCE ADD (
  CONSTRAINT INSURANCE_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INSURANCE
  DROP CONSTRAINT INSURANCE_PK;

ALTER TABLE ADR.INSURANCE ADD (
  CONSTRAINT INSURANCE_PK
  PRIMARY KEY
  (INSURANCE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.INSURANCE_H
  DROP CONSTRAINT INSURANCEH_PK;

ALTER TABLE ADR.INSURANCE_H ADD (
  CONSTRAINT INSURANCEH_PK
  PRIMARY KEY
  (INSURANCE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.IN_PROCESS_FINANCIALS
  DROP CONSTRAINT INPROCFNCL_PRSN_FK;


ALTER TABLE ADR.IN_PROCESS_FINANCIALS ADD (
  CONSTRAINT INPROCFNCL_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.IN_PROCESS_FINANCIALS
  DROP CONSTRAINT INPROCFNCL_PK;

ALTER TABLE ADR.IN_PROCESS_FINANCIALS ADD (
  CONSTRAINT INPROCFNCL_PK
  PRIMARY KEY
  (IN_PROCESS_FINANCIAL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.INELIGIBLE_RULING_H
  DROP CONSTRAINT INELIGBRLH_PK;

ALTER TABLE ADR.INELIGIBLE_RULING_H ADD (
  CONSTRAINT INELIGBRLH_PK
  PRIMARY KEY
  (INELIGIBLE_RULING_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.INELIGIBLE_RULING
  DROP CONSTRAINT INELIGBRLG_PRSN_FK;


ALTER TABLE ADR.INELIGIBLE_RULING ADD (
  CONSTRAINT INELIGBRLG_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INELIGIBLE_RULING
  DROP CONSTRAINT INELIGBRLG_PK;

ALTER TABLE ADR.INELIGIBLE_RULING ADD (
  CONSTRAINT INELIGBRLG_PK
  PRIMARY KEY
  (INELIGIBLE_RULING_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.INCOMPETENT_RULING_H
  DROP CONSTRAINT INCOMPRULH_PK;

ALTER TABLE ADR.INCOMPETENT_RULING_H ADD (
  CONSTRAINT INCOMPRULH_PK
  PRIMARY KEY
  (INCOMPETENT_RULING_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.INCOMPETENT_RULING
  DROP CONSTRAINT INCOMPRULE_PRSN_FK;


ALTER TABLE ADR.INCOMPETENT_RULING ADD (
  CONSTRAINT INCOMPRULE_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOMPETENT_RULING
  DROP CONSTRAINT INCOMPRULE_PK;

ALTER TABLE ADR.INCOMPETENT_RULING ADD (
  CONSTRAINT INCOMPRULE_PK
  PRIMARY KEY
  (INCOMPETENT_RULING_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.INCOME_TEST
  DROP CONSTRAINT INCMTST_PRSN_FK;


ALTER TABLE ADR.INCOME_TEST ADD (
  CONSTRAINT INCMTST_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST
  DROP CONSTRAINT INCMTST_PK;

ALTER TABLE ADR.INCOME_TEST ADD (
  CONSTRAINT INCMTST_PK
  PRIMARY KEY
  (INCOME_TEST_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.INCOME_TEST_H
  DROP CONSTRAINT INCMTSTH_PK;

ALTER TABLE ADR.INCOME_TEST_H ADD (
  CONSTRAINT INCMTSTH_PK
  PRIMARY KEY
  (INCOME_TEST_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.INCOME_TEST_DETAIL
  DROP CONSTRAINT INCMTSTDTL_PK;

ALTER TABLE ADR.INCOME_TEST_DETAIL ADD (
  CONSTRAINT INCMTSTDTL_PK
  PRIMARY KEY
  (INCOME_TEST_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.INCOME_TEST_DETAIL
  DROP CONSTRAINT INCMTSTDTL_INCMTST_FK;


ALTER TABLE ADR.INCOME_TEST_DETAIL ADD (
  CONSTRAINT INCMTSTDTL_INCMTST_FK 
  FOREIGN KEY (INCOME_TEST_ID) 
  REFERENCES ADR.INCOME_TEST (INCOME_TEST_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_DETAIL_H
  DROP CONSTRAINT INCMTSTDTH_PK;

ALTER TABLE ADR.INCOME_TEST_DETAIL_H ADD (
  CONSTRAINT INCMTSTDTH_PK
  PRIMARY KEY
  (INCOME_TEST_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H
  DROP CONSTRAINT HNDREQVETH_PK;

ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H ADD (
  CONSTRAINT HNDREQVETH_PK
  PRIMARY KEY
  (HANDBOOK_REQUEST_VETERAN_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS
  DROP CONSTRAINT HNDMALSTA_PK;

ALTER TABLE ADR.HANDBOOK_MAIL_STATUS ADD (
  CONSTRAINT HNDMALSTA_PK
  PRIMARY KEY
  (HANDBOOK_MAIL_STATUS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H
  DROP CONSTRAINT HNDMALSTAH_PK;

ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H ADD (
  CONSTRAINT HNDMALSTAH_PK
  PRIMARY KEY
  (HANDBOOK_MAIL_STATUS_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H
  DROP CONSTRAINT HNDMALQUEH_PK;

ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H ADD (
  CONSTRAINT HNDMALQUEH_PK
  PRIMARY KEY
  (HANDBOOK_MAIL_QUEUE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_DOCUMENT
  DROP CONSTRAINT HNDDOC_PK;

ALTER TABLE ADR.HANDBOOK_DOCUMENT ADD (
  CONSTRAINT HNDDOC_PK
  PRIMARY KEY
  (HANDBOOK_DOCUMENT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST
  DROP CONSTRAINT HNDBATREQ_PK;

ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST ADD (
  CONSTRAINT HNDBATREQ_PK
  PRIMARY KEY
  (HANDBOOK_BATCH_REQUEST_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H
  DROP CONSTRAINT HNDBATREQH_PK;

ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H ADD (
  CONSTRAINT HNDBATREQH_PK
  PRIMARY KEY
  (HANDBOOK_BATCH_REQUEST_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE
  DROP CONSTRAINT HLTHBENPRF_PK;

ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE ADD (
  CONSTRAINT HLTHBENPRF_PK
  PRIMARY KEY
  (HEALTH_BENEFIT_PROFILE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE_H
  DROP CONSTRAINT HLTHBENPRFH_PK;

ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE_H ADD (
  CONSTRAINT HLTHBENPRFH_PK
  PRIMARY KEY
  (HEALTH_BENEFIT_PROFILE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN
  DROP CONSTRAINT HLTHBENPLN_PK;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN ADD (
  CONSTRAINT HLTHBENPLN_PK
  PRIMARY KEY
  (HEALTH_BENEFIT_PLAN_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_H
  DROP CONSTRAINT HLTHBENPLNH_PK;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_H ADD (
  CONSTRAINT HLTHBENPLNH_PK
  PRIMARY KEY
  (HEALTH_BENEFIT_PLAN_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL
  DROP CONSTRAINT HLTHBENPLNDTL_HLTHPLNNAMEID_FK;


ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL ADD (
  CONSTRAINT HLTHBENPLNDTL_HLTHPLNNAMEID_FK 
  FOREIGN KEY (HLTH_BEN_PLAN_NAME_ID) 
  REFERENCES ADR.HEALTH_BENEFIT_PLAN_NAME (HLTH_BEN_PLAN_NAME_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL
  DROP CONSTRAINT HLTHBENPLANDET_PK;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL ADD (
  CONSTRAINT HLTHBENPLANDET_PK
  PRIMARY KEY
  (HEALTH_BENEFIT_PLAN_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC
  DROP CONSTRAINT HLTHBENPLANDESC_FK;


ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC ADD (
  CONSTRAINT HLTHBENPLANDESC_FK 
  FOREIGN KEY (HEALTH_BENEFIT_PLAN_DETAIL_ID) 
  REFERENCES ADR.HEALTH_BENEFIT_PLAN_DETAIL (HEALTH_BENEFIT_PLAN_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE
  DROP CONSTRAINT HLTBNFPRF_PRSN_FK;


ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE ADD (
  CONSTRAINT HLTBNFPRF_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN
  DROP CONSTRAINT HLTBNFPLN_HLTBNFPRF_FK;


ALTER TABLE ADR.HEALTH_BENEFIT_PLAN ADD (
  CONSTRAINT HLTBNFPLN_HLTBNFPRF_FK 
  FOREIGN KEY (HEALTH_BENEFIT_PROFILE_ID) 
  REFERENCES ADR.HEALTH_BENEFIT_PROFILE (HEALTH_BENEFIT_PROFILE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.HL7_TRANSACTION_LOG
  DROP CONSTRAINT HL7_PERSONID_FK;


ALTER TABLE ADR.HL7_TRANSACTION_LOG ADD (
  CONSTRAINT HL7_PERSONID_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HL7_ARCHIVE_TRANSACTION_LOG
  DROP CONSTRAINT HL7_ARCLOG_PK;

ALTER TABLE ADR.HL7_ARCHIVE_TRANSACTION_LOG ADD (
  CONSTRAINT HL7_ARCLOG_PK
  PRIMARY KEY
  (HL7_TRANSACTION_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HL7_TRANSACTION_LOG
  DROP CONSTRAINT HL7LOG_PK;

ALTER TABLE ADR.HL7_TRANSACTION_LOG ADD (
  CONSTRAINT HL7LOG_PK
  PRIMARY KEY
  (HL7_TRANSACTION_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H
  DROP CONSTRAINT HEALTH_BEN_PLAN_DETAIL_H_PK;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H ADD (
  CONSTRAINT HEALTH_BEN_PLAN_DETAIL_H_PK
  PRIMARY KEY
  (HEALTH_BENEFIT_PLAN_DET_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME
  DROP CONSTRAINT HEALTH_BENEFIT_PLAN_NAME_PK;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME ADD (
  CONSTRAINT HEALTH_BENEFIT_PLAN_NAME_PK
  PRIMARY KEY
  (HLTH_BEN_PLAN_NAME_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H
  DROP CONSTRAINT HEALTH_BENEFIT_PLAN_NAME_H_PK;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H ADD (
  CONSTRAINT HEALTH_BENEFIT_PLAN_NAME_H_PK
  PRIMARY KEY
  (HLTH_BEN_PLAN_NAME_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC
  DROP CONSTRAINT HEALTH_BENEFIT_PLAN_DESC_PK;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC ADD (
  CONSTRAINT HEALTH_BENEFIT_PLAN_DESC_PK
  PRIMARY KEY
  (HLTH_BEN_PLAN_DESC_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H
  DROP CONSTRAINT HEALTH_BENEFIT_PLAN_DESC_H_PK;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H ADD (
  CONSTRAINT HEALTH_BENEFIT_PLAN_DESC_H_PK
  PRIMARY KEY
  (HLTH_BEN_PLAN_DESC_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION
  DROP CONSTRAINT HEALTHAPP_PRSN_FK;


ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION ADD (
  CONSTRAINT HEALTHAPP_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION
  DROP CONSTRAINT HEALTHAPP_PK;

ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION ADD (
  CONSTRAINT HEALTHAPP_PK
  PRIMARY KEY
  (HEALTH_BENEFITS_APPLICATION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H
  DROP CONSTRAINT HEALTHAPPH_PK;

ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H ADD (
  CONSTRAINT HEALTHAPPH_PK
  PRIMARY KEY
  (HEALTH_BENEFITS_APPLN_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_CARE_PROVIDER
  DROP CONSTRAINT HCP_PK;

ALTER TABLE ADR.HEALTH_CARE_PROVIDER ADD (
  CONSTRAINT HCP_PK
  PRIMARY KEY
  (HEALTH_CARE_PROVIDER_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_CARE_PROVIDER_H
  DROP CONSTRAINT HCPH_PK;

ALTER TABLE ADR.HEALTH_CARE_PROVIDER_H ADD (
  CONSTRAINT HCPH_PK
  PRIMARY KEY
  (HEALTH_CARE_PROVIDER_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE
  DROP CONSTRAINT GTA_TRNSMT_PRSN_FK;


ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE ADD (
  CONSTRAINT GTA_TRNSMT_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE
  DROP CONSTRAINT GTA_GEOCODE_STATION_FK;


ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE ADD (
  CONSTRAINT GTA_GEOCODE_STATION_FK 
  FOREIGN KEY (GEOCODE_STATION_ID) 
  REFERENCES ADR.GEOCODE_STATION (GEOCODE_STATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.GEOCODE_STAGE
  DROP CONSTRAINT GS_TRNSMT_PRSN_FK;


ALTER TABLE ADR.GEOCODE_STAGE ADD (
  CONSTRAINT GS_TRNSMT_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.GEOCODE_TRANSMIT
  DROP CONSTRAINT GEOCODE_TRANSMIT_PK;

ALTER TABLE ADR.GEOCODE_TRANSMIT ADD (
  CONSTRAINT GEOCODE_TRANSMIT_PK
  PRIMARY KEY
  (RECORD_CREATED_DATE, GEOCODE_TRANSMIT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.GEOCODE_TRANSMIT_H
  DROP CONSTRAINT GEOCODE_TRANSMIT_H_PK;

ALTER TABLE ADR.GEOCODE_TRANSMIT_H ADD (
  CONSTRAINT GEOCODE_TRANSMIT_H_PK
  PRIMARY KEY
  (GEOCODE_TRANSMIT_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE
  DROP CONSTRAINT GEOCODE_TRANSMIT_ARCHIVE_PK;

ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE ADD (
  CONSTRAINT GEOCODE_TRANSMIT_ARCHIVE_PK
  PRIMARY KEY
  (RECORD_CREATED_DATE, GEOCODE_TRANSMIT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.GEOCODE_STAGE
  DROP CONSTRAINT GEOCODE_STG_STATION_FK;


ALTER TABLE ADR.GEOCODE_STAGE ADD (
  CONSTRAINT GEOCODE_STG_STATION_FK 
  FOREIGN KEY (GEOCODE_STATION_ID) 
  REFERENCES ADR.GEOCODE_STATION (GEOCODE_STATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.GEOCODE_STATION
  DROP CONSTRAINT GEOCODE_STATION_PK;

ALTER TABLE ADR.GEOCODE_STATION ADD (
  CONSTRAINT GEOCODE_STATION_PK
  PRIMARY KEY
  (GEOCODE_STATION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.GEOCODE_STATION_H
  DROP CONSTRAINT GEOCODE_STATION_H_PK;

ALTER TABLE ADR.GEOCODE_STATION_H ADD (
  CONSTRAINT GEOCODE_STATION_H_PK
  PRIMARY KEY
  (GEOCODE_STATION_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.GEOCODE_TRANSMIT
  DROP CONSTRAINT GEOCODE_STATION_FK;


ALTER TABLE ADR.GEOCODE_TRANSMIT ADD (
  CONSTRAINT GEOCODE_STATION_FK 
  FOREIGN KEY (GEOCODE_STATION_ID) 
  REFERENCES ADR.GEOCODE_STATION (GEOCODE_STATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.GEOCODE_STAGE
  DROP CONSTRAINT GEOCODE_STAGE_PK;

ALTER TABLE ADR.GEOCODE_STAGE ADD (
  CONSTRAINT GEOCODE_STAGE_PK
  PRIMARY KEY
  (RECORD_CREATED_DATE, GEOCODE_STAGE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.GEOCODE_STAGE_MONTHLY
  DROP CONSTRAINT GEOCODE_STAGE_MONTHLY_PKPK;

ALTER TABLE ADR.GEOCODE_STAGE_MONTHLY ADD (
  CONSTRAINT GEOCODE_STAGE_MONTHLY_PKPK
  PRIMARY KEY
  (RECORD_CREATED_DATE, GEOCODE_STAGE_MONTHLY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.GEOCODE_TRANSMIT
  DROP CONSTRAINT GEOCODETRANS_VCELIG_FK;


ALTER TABLE ADR.GEOCODE_TRANSMIT ADD (
  CONSTRAINT GEOCODETRANS_VCELIG_FK 
  FOREIGN KEY (VCELIGIBILITY_ID) 
  REFERENCES ADR.VCELIGIBILITY (VCELIGIBILITY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE
  DROP CONSTRAINT GEOCD_TRNSMIT_ARCH_ADDR_D_FK;


ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE ADD (
  CONSTRAINT GEOCD_TRNSMIT_ARCH_ADDR_D_FK 
  FOREIGN KEY (ADDRESS_H_ID) 
  REFERENCES ADR.ADDRESS_H (ADDRESS_H_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.GEOCODE_TRANSMIT
  DROP CONSTRAINT GEOCD_TRNSMIT_ADDR_D_FK;


ALTER TABLE ADR.GEOCODE_TRANSMIT ADD (
  CONSTRAINT GEOCD_TRNSMIT_ADDR_D_FK 
  FOREIGN KEY (ADDRESS_H_ID) 
  REFERENCES ADR.ADDRESS_H (ADDRESS_H_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.GEOCODE_STAGE
  DROP CONSTRAINT GEOCD_STAGE_ADDR_D_FK;


ALTER TABLE ADR.GEOCODE_STAGE ADD (
  CONSTRAINT GEOCD_STAGE_ADDR_D_FK 
  FOREIGN KEY (ADDRESS_H_ID) 
  REFERENCES ADR.ADDRESS_H (ADDRESS_H_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE
  DROP CONSTRAINT GEOCDTRANSARCH_VCELIG_FK;


ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE ADD (
  CONSTRAINT GEOCDTRANSARCH_VCELIG_FK 
  FOREIGN KEY (VCELIGIBILITY_ID) 
  REFERENCES ADR.VCELIGIBILITY (VCELIGIBILITY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE
  DROP CONSTRAINT FUTURE_DIS_ID_FK;


ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE ADD (
  CONSTRAINT FUTURE_DIS_ID_FK 
  FOREIGN KEY (FUTURE_DISCHARGE_SRC_TYPE_ID) 
  REFERENCES ADR.FUTURE_DISCHARGE_SRC_TYPE (FUTURE_DISCHARGE_SRC_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE
  DROP CONSTRAINT FUTURE_DISCHARGE_SRC_TYPE_PK;

ALTER TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE ADD (
  CONSTRAINT FUTURE_DISCHARGE_SRC_TYPE_PK
  PRIMARY KEY
  (FUTURE_DISCHARGE_SRC_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT
  DROP CONSTRAINT FINSTATE_PRSN_FK;


ALTER TABLE ADR.FINANCIAL_STATEMENT ADD (
  CONSTRAINT FINSTATE_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT
  DROP CONSTRAINT FINSTATE_PRSNREL_FK;


ALTER TABLE ADR.FINANCIAL_STATEMENT ADD (
  CONSTRAINT FINSTATE_PRSNREL_FK 
  FOREIGN KEY (PERSON_RELATION_ID) 
  REFERENCES ADR.PERSON_RELATION (PERSON_RELATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT
  DROP CONSTRAINT FINSTATE_PK;

ALTER TABLE ADR.FINANCIAL_STATEMENT ADD (
  CONSTRAINT FINSTATE_PK
  PRIMARY KEY
  (FINANCIAL_STATEMENT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT
  DROP CONSTRAINT FINSTATE_FINSTATE_FK;


ALTER TABLE ADR.FINANCIAL_STATEMENT ADD (
  CONSTRAINT FINSTATE_FINSTATE_FK 
  FOREIGN KEY (REF_FINANCIAL_STATEMENT_ID) 
  REFERENCES ADR.FINANCIAL_STATEMENT (FINANCIAL_STATEMENT_ID)
  DEFERRABLE INITIALLY DEFERRED
  DISABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT_H
  DROP CONSTRAINT FINSTATEH_PK;

ALTER TABLE ADR.FINANCIAL_STATEMENT_H ADD (
  CONSTRAINT FINSTATEH_PK
  PRIMARY KEY
  (FINANCIAL_STATEMENT_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL
  DROP CONSTRAINT FININCMDTL_PK;

ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL ADD (
  CONSTRAINT FININCMDTL_PK
  PRIMARY KEY
  (FINANCIAL_INCOME_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL
  DROP CONSTRAINT FININCMDTL_FINSTATE_FK;


ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL ADD (
  CONSTRAINT FININCMDTL_FINSTATE_FK 
  FOREIGN KEY (FINANCIAL_STATEMENT_ID) 
  REFERENCES ADR.FINANCIAL_STATEMENT (FINANCIAL_STATEMENT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H
  DROP CONSTRAINT FININCMDTH_PK;

ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H ADD (
  CONSTRAINT FININCMDTH_PK
  PRIMARY KEY
  (FINANCIAL_INCOME_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL
  DROP CONSTRAINT FINEXPDTL_PK;

ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL ADD (
  CONSTRAINT FINEXPDTL_PK
  PRIMARY KEY
  (FINANCIAL_EXPENSE_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL
  DROP CONSTRAINT FINEXPDTL_FINSTATE_FK;


ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL ADD (
  CONSTRAINT FINEXPDTL_FINSTATE_FK 
  FOREIGN KEY (FINANCIAL_STATEMENT_ID) 
  REFERENCES ADR.FINANCIAL_STATEMENT (FINANCIAL_STATEMENT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H
  DROP CONSTRAINT FINEXPDTLH_PK;

ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H ADD (
  CONSTRAINT FINEXPDTLH_PK
  PRIMARY KEY
  (FINANCIAL_EXPENSE_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL
  DROP CONSTRAINT FINDBTDTL_PK;

ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL ADD (
  CONSTRAINT FINDBTDTL_PK
  PRIMARY KEY
  (FINANCIAL_DEBT_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL
  DROP CONSTRAINT FINDBTDTL_FINSTATE_FK;


ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL ADD (
  CONSTRAINT FINDBTDTL_FINSTATE_FK 
  FOREIGN KEY (FINANCIAL_STATEMENT_ID) 
  REFERENCES ADR.FINANCIAL_STATEMENT (FINANCIAL_STATEMENT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H
  DROP CONSTRAINT FINDBTDTLH_PK;

ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H ADD (
  CONSTRAINT FINDBTDTLH_PK
  PRIMARY KEY
  (FINANCIAL_DEBT_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL
  DROP CONSTRAINT FINASTDTL_PK;

ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL ADD (
  CONSTRAINT FINASTDTL_PK
  PRIMARY KEY
  (FINANCIAL_ASSET_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL
  DROP CONSTRAINT FINASTDTL_FINSTATE_FK;


ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL ADD (
  CONSTRAINT FINASTDTL_FINSTATE_FK 
  FOREIGN KEY (FINANCIAL_STATEMENT_ID) 
  REFERENCES ADR.FINANCIAL_STATEMENT (FINANCIAL_STATEMENT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H
  DROP CONSTRAINT FINASTDTLH_PK;

ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H ADD (
  CONSTRAINT FINASTDTLH_PK
  PRIMARY KEY
  (FINANCIAL_ASSET_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.FEE_BASIS
  DROP CONSTRAINT FEEBASIS_PRSN_FK;


ALTER TABLE ADR.FEE_BASIS ADD (
  CONSTRAINT FEEBASIS_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FEE_BASIS
  DROP CONSTRAINT FEEBASIS_PK;

ALTER TABLE ADR.FEE_BASIS ADD (
  CONSTRAINT FEEBASIS_PK
  PRIMARY KEY
  (FEE_BASIS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.FEE_BASIS_H
  DROP CONSTRAINT FEEBASISH_PK;

ALTER TABLE ADR.FEE_BASIS_H ADD (
  CONSTRAINT FEEBASISH_PK
  PRIMARY KEY
  (FEE_BASIS_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ENROLLMENT_OVERRIDE
  DROP CONSTRAINT ENROLOVER_PRSN_FK;


ALTER TABLE ADR.ENROLLMENT_OVERRIDE ADD (
  CONSTRAINT ENROLOVER_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_OVERRIDE
  DROP CONSTRAINT ENROLOVER_PK;

ALTER TABLE ADR.ENROLLMENT_OVERRIDE ADD (
  CONSTRAINT ENROLOVER_PK
  PRIMARY KEY
  (ENROLLMENT_OVERRIDE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H
  DROP CONSTRAINT ENROLOVERH_PK;

ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H ADD (
  CONSTRAINT ENROLOVERH_PK
  PRIMARY KEY
  (ENROLLMENT_OVERRIDE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_FORM_TYPE
  DROP CONSTRAINT ENRL_FORM_TYP_RPT_FORM_TYP_FK;


ALTER TABLE ADR.RPT_FORM_TYPE ADD (
  CONSTRAINT ENRL_FORM_TYP_RPT_FORM_TYP_FK 
  FOREIGN KEY (ENROLLMENT_FORM_TYPE_ID) 
  REFERENCES VOA.ENROLLMENT_FORM_TYPE (ENROLLMENT_FORM_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION
  DROP CONSTRAINT ENRLMNTDET_PRSN_FK;


ALTER TABLE ADR.ENROLLMENT_DETERMINATION ADD (
  CONSTRAINT ENRLMNTDET_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION
  DROP CONSTRAINT ENRLMNTDET_PK;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION ADD (
  CONSTRAINT ENRLMNTDET_PK
  PRIMARY KEY
  (ENROLLMENT_DETERMINATION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION
  DROP CONSTRAINT ENRLMNTDET_EGTSETTING_FK;


ALTER TABLE ADR.ENROLLMENT_DETERMINATION ADD (
  CONSTRAINT ENRLMNTDET_EGTSETTING_FK 
  FOREIGN KEY (EGT_SETTING_ID) 
  REFERENCES ADR.EGT_SETTING (EGT_SETTING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H
  DROP CONSTRAINT ENRLMNTDEH_PK;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H ADD (
  CONSTRAINT ENRLMNTDEH_PK
  PRIMARY KEY
  (ENROLLMENT_DETERMINATION_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EMPLOYMENT
  DROP CONSTRAINT EMPLOY_PRSN_FK;


ALTER TABLE ADR.EMPLOYMENT ADD (
  CONSTRAINT EMPLOY_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMPLOYMENT
  DROP CONSTRAINT EMPLOY_PRSNREL_FK;


ALTER TABLE ADR.EMPLOYMENT ADD (
  CONSTRAINT EMPLOY_PRSNREL_FK 
  FOREIGN KEY (PERSON_RELATION_ID) 
  REFERENCES ADR.PERSON_RELATION (PERSON_RELATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.EMPLOYMENT
  DROP CONSTRAINT EMPLOY_PK;

ALTER TABLE ADR.EMPLOYMENT ADD (
  CONSTRAINT EMPLOY_PK
  PRIMARY KEY
  (EMPLOYMENT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EMPLOYMENT_H
  DROP CONSTRAINT EMPLOYMENT_H_CHK;

ALTER TABLE ADR.EMPLOYMENT_H ADD (
  CONSTRAINT EMPLOYMENT_H_CHK
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMPLOYMENT_H
  DROP CONSTRAINT EMPLOYH_PK;

ALTER TABLE ADR.EMPLOYMENT_H ADD (
  CONSTRAINT EMPLOYH_PK
  PRIMARY KEY
  (EMPLOYMENT_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EMAIL
  DROP CONSTRAINT EML_SITE_OF_CNG_FK;


ALTER TABLE ADR.EMAIL ADD (
  CONSTRAINT EML_SITE_OF_CNG_FK 
  FOREIGN KEY (SITE_OF_CHANGE_ID) 
  REFERENCES ADR.LOOKUP_TYPE (LOOKUP_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EMERGENCY_RESPONSE
  DROP CONSTRAINT EMERGRESP_PRSN_FK;


ALTER TABLE ADR.EMERGENCY_RESPONSE ADD (
  CONSTRAINT EMERGRESP_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMERGENCY_RESPONSE
  DROP CONSTRAINT EMERGRESP_PK;

ALTER TABLE ADR.EMERGENCY_RESPONSE ADD (
  CONSTRAINT EMERGRESP_PK
  PRIMARY KEY
  (EMERGENCY_RESPONSE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EMERGENCY_RESPONSE_H
  DROP CONSTRAINT EMERGRESH_PK;

ALTER TABLE ADR.EMERGENCY_RESPONSE_H ADD (
  CONSTRAINT EMERGRESH_PK
  PRIMARY KEY
  (EMERGENCY_RESPONSE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EMAIL
  DROP CONSTRAINT EMAIL_PRSN_FK;


ALTER TABLE ADR.EMAIL ADD (
  CONSTRAINT EMAIL_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMAIL
  DROP CONSTRAINT EMAIL_PK;

ALTER TABLE ADR.EMAIL ADD (
  CONSTRAINT EMAIL_PK
  PRIMARY KEY
  (EMAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EMAIL
  DROP CONSTRAINT EMAIL_INSURANCE_FK;


ALTER TABLE ADR.EMAIL ADD (
  CONSTRAINT EMAIL_INSURANCE_FK 
  FOREIGN KEY (INSURANCE_ID) 
  REFERENCES ADR.INSURANCE (INSURANCE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMAIL_H
  DROP CONSTRAINT EMAILH_PK;

ALTER TABLE ADR.EMAIL_H ADD (
  CONSTRAINT EMAILH_PK
  PRIMARY KEY
  (EMAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ELIGIBILITY_STATUS_REASON
  DROP CONSTRAINT ELIGIBILITY_STATUS_REASON_PK;

ALTER TABLE ADR.ELIGIBILITY_STATUS_REASON ADD (
  CONSTRAINT ELIGIBILITY_STATUS_REASON_PK
  PRIMARY KEY
  (ELIGIBILITY_STATUS_REASON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION
  DROP CONSTRAINT ELGBTYVRFY_PRSN_FK;


ALTER TABLE ADR.ELIGIBILITY_VERIFICATION ADD (
  CONSTRAINT ELGBTYVRFY_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION
  DROP CONSTRAINT ELGBTYVRFY_PK;

ALTER TABLE ADR.ELIGIBILITY_VERIFICATION ADD (
  CONSTRAINT ELGBTYVRFY_PK
  PRIMARY KEY
  (ELIGIBILITY_VERIFICATION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H
  DROP CONSTRAINT ELGBTYVRFH_PK;

ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H ADD (
  CONSTRAINT ELGBTYVRFH_PK
  PRIMARY KEY
  (ELIGIBILITY_VERIFICATION_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION
  DROP CONSTRAINT ELGBTYVERIFI_REASONID_FK;


ALTER TABLE ADR.ELIGIBILITY_VERIFICATION ADD (
  CONSTRAINT ELGBTYVERIFI_REASONID_FK 
  FOREIGN KEY (ELGBTY_STATUS_REASON_ID) 
  REFERENCES ADR.ELIGIBILITY_STATUS_REASON (ELIGIBILITY_STATUS_REASON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION
  DROP CONSTRAINT ELGBDETER_PK;

ALTER TABLE ADR.ELIGIBILITY_DETERMINATION ADD (
  CONSTRAINT ELGBDETER_PK
  PRIMARY KEY
  (ELIGIBILITY_DETERMINATION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION
  DROP CONSTRAINT ELGBDETER_ENRLMNTDET_FK;


ALTER TABLE ADR.ELIGIBILITY_DETERMINATION ADD (
  CONSTRAINT ELGBDETER_ENRLMNTDET_FK 
  FOREIGN KEY (ENROLLMENT_DETERMINATION_ID) 
  REFERENCES ADR.ENROLLMENT_DETERMINATION (ENROLLMENT_DETERMINATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H
  DROP CONSTRAINT ELGBDETERH_PK;

ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H ADD (
  CONSTRAINT ELGBDETERH_PK
  PRIMARY KEY
  (ELIGIBILITY_DETERMINATION_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EHR_TRANSACTION_LOG
  DROP CONSTRAINT EHR_TXN_LOG_TXN_DATA_FK;


ALTER TABLE ADR.EHR_TRANSACTION_LOG ADD (
  CONSTRAINT EHR_TXN_LOG_TXN_DATA_FK 
  FOREIGN KEY (EHR_TRANSACTION_DATA_ID) 
  REFERENCES ADR.EHR_TRANSACTION_DATA (EHR_TRANSACTION_DATA_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EHR_TRANSACTION_LOG
  DROP CONSTRAINT EHR_TXN_LOG_PK;

ALTER TABLE ADR.EHR_TRANSACTION_LOG ADD (
  CONSTRAINT EHR_TXN_LOG_PK
  PRIMARY KEY
  (EHR_TRANSACTION_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EHR_TRANSACTION_LOG
  DROP CONSTRAINT EHR_TXN_LOG_PERSONID_FK;


ALTER TABLE ADR.EHR_TRANSACTION_LOG ADD (
  CONSTRAINT EHR_TXN_LOG_PERSONID_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EHR_TRANSACTION_DATA
  DROP CONSTRAINT EHR_TXN_DATA_PK;

ALTER TABLE ADR.EHR_TRANSACTION_DATA ADD (
  CONSTRAINT EHR_TXN_DATA_PK
  PRIMARY KEY
  (EHR_TRANSACTION_DATA_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_SITE_STATISTICS
  DROP CONSTRAINT EGTSTSTIC_PK;

ALTER TABLE ADR.EGT_SITE_STATISTICS ADD (
  CONSTRAINT EGTSTSTIC_PK
  PRIMARY KEY
  (EGT_SITE_STATISTICS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_SITE_STATISTICS
  DROP CONSTRAINT EGTSTSTIC_EGTSTAT_FK;


ALTER TABLE ADR.EGT_SITE_STATISTICS ADD (
  CONSTRAINT EGTSTSTIC_EGTSTAT_FK 
  FOREIGN KEY (EGT_STATISTICS_ID) 
  REFERENCES ADR.EGT_STATISTICS (EGT_STATISTICS_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_SITE_STATISTICS_H
  DROP CONSTRAINT EGTSTSTICH_PK;

ALTER TABLE ADR.EGT_SITE_STATISTICS_H ADD (
  CONSTRAINT EGTSTSTICH_PK
  PRIMARY KEY
  (EGT_SITE_STATISTICS_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_STATISTICS
  DROP CONSTRAINT EGTSTAT_PK;

ALTER TABLE ADR.EGT_STATISTICS ADD (
  CONSTRAINT EGTSTAT_PK
  PRIMARY KEY
  (EGT_STATISTICS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_STATISTICS
  DROP CONSTRAINT EGTSTAT_EGTSETTING_FK;


ALTER TABLE ADR.EGT_STATISTICS ADD (
  CONSTRAINT EGTSTAT_EGTSETTING_FK 
  FOREIGN KEY (EGT_SETTING_ID) 
  REFERENCES ADR.EGT_SETTING (EGT_SETTING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_STATISTICS_H
  DROP CONSTRAINT EGTSTATH_PK;

ALTER TABLE ADR.EGT_STATISTICS_H ADD (
  CONSTRAINT EGTSTATH_PK
  PRIMARY KEY
  (EGT_STATISTICS_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_SETTING_H
  DROP CONSTRAINT EGTSETTINH_PK;

ALTER TABLE ADR.EGT_SETTING_H ADD (
  CONSTRAINT EGTSETTINH_PK
  PRIMARY KEY
  (EGT_SETTING_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_SETTING
  DROP CONSTRAINT EGTSETTING_PK;

ALTER TABLE ADR.EGT_SETTING ADD (
  CONSTRAINT EGTSETTING_PK
  PRIMARY KEY
  (EGT_SETTING_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_SETTING
  DROP CONSTRAINT EGTSETTING_EGTSETTING_FK;


ALTER TABLE ADR.EGT_SETTING ADD (
  CONSTRAINT EGTSETTING_EGTSETTING_FK 
  FOREIGN KEY (REFERENCE_EGT_SETTING_ID) 
  REFERENCES ADR.EGT_SETTING (EGT_SETTING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.DELIVERY_PREFERENCE
  DROP CONSTRAINT DLVPRF_PRS_FK;


ALTER TABLE ADR.DELIVERY_PREFERENCE ADD (
  CONSTRAINT DLVPRF_PRS_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.DELIVERY_PREFERENCE
  DROP CONSTRAINT DLVPRF_PK;

ALTER TABLE ADR.DELIVERY_PREFERENCE ADD (
  CONSTRAINT DLVPRF_PK
  PRIMARY KEY
  (DELIVERY_PREFERENCE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.DELIVERY_PREFERENCE_H
  DROP CONSTRAINT DLVPRF_H_PK;

ALTER TABLE ADR.DELIVERY_PREFERENCE_H ADD (
  CONSTRAINT DLVPRF_H_PK
  PRIMARY KEY
  (DELIVERY_PREFERENCE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL
  DROP CONSTRAINT DLVPRFEM_PK;

ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL ADD (
  CONSTRAINT DLVPRFEM_PK
  PRIMARY KEY
  (DELIVERY_PREFERENCE_EMAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H
  DROP CONSTRAINT DLVPRFEM_H_PK;

ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H ADD (
  CONSTRAINT DLVPRFEM_H_PK
  PRIMARY KEY
  (DELIVERY_PREFERENCE_EMAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL
  DROP CONSTRAINT DLVPRFEM_DLVPRF_FK;


ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL ADD (
  CONSTRAINT DLVPRFEM_DLVPRF_FK 
  FOREIGN KEY (DELIVERY_PREFERENCE_ID) 
  REFERENCES ADR.DELIVERY_PREFERENCE (DELIVERY_PREFERENCE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.DEPLOYMENT
  DROP CONSTRAINT DEP_PK;

ALTER TABLE ADR.DEPLOYMENT ADD (
  CONSTRAINT DEP_PK
  PRIMARY KEY
  (DEPLOYMENT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.DEPLOYMENT_H
  DROP CONSTRAINT DEP_H_PK;

ALTER TABLE ADR.DEPLOYMENT_H ADD (
  CONSTRAINT DEP_H_PK
  PRIMARY KEY
  (DEPLOYMENT_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.DEPLOYMENT
  DROP CONSTRAINT DEP_ACT_FK;


ALTER TABLE ADR.DEPLOYMENT ADD (
  CONSTRAINT DEP_ACT_FK 
  FOREIGN KEY (ACTIVATION_ID) 
  REFERENCES ADR.ACTIVATION (ACTIVATION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CORRESPONDENCE
  DROP CONSTRAINT CORRPNDNC_CORRPNDNC_TYPE_FK;


ALTER TABLE ADR.CORRESPONDENCE ADD (
  CONSTRAINT CORRPNDNC_CORRPNDNC_TYPE_FK 
  FOREIGN KEY (CORRESPONDENCE_TYPE_ID) 
  REFERENCES ADR.CORRESPONDENCE_TYPE (CORRESPONDENCE_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CORRESPONDENCE
  DROP CONSTRAINT CORRPNDNC_CORRPNDNC_STATUS_FK;


ALTER TABLE ADR.CORRESPONDENCE ADD (
  CONSTRAINT CORRPNDNC_CORRPNDNC_STATUS_FK 
  FOREIGN KEY (CORRESPONDENCE_STATUS_ID) 
  REFERENCES ADR.CORRESPONDENCE_STATUS (CORRESPONDENCE_STATUS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CORRESPONDENCE
  DROP CONSTRAINT CORRPNDNC_CORRPNDNC_DOC_FK;


ALTER TABLE ADR.CORRESPONDENCE ADD (
  CONSTRAINT CORRPNDNC_CORRPNDNC_DOC_FK 
  FOREIGN KEY (CORRESPONDENCE_DOCUMENT_ID) 
  REFERENCES ADR.CORRESPONDENCE_DOCUMENT (CORRESPONDENCE_DOCUMENT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CORRESPONDENCE_TYPE
  DROP CONSTRAINT CORRESPONDENCE_TYPE_PK;

ALTER TABLE ADR.CORRESPONDENCE_TYPE ADD (
  CONSTRAINT CORRESPONDENCE_TYPE_PK
  PRIMARY KEY
  (CORRESPONDENCE_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CORRESPONDENCE_STATUS
  DROP CONSTRAINT CORRESPONDENCE_STATUS_PK;

ALTER TABLE ADR.CORRESPONDENCE_STATUS ADD (
  CONSTRAINT CORRESPONDENCE_STATUS_PK
  PRIMARY KEY
  (CORRESPONDENCE_STATUS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CORRESPONDENCE
  DROP CONSTRAINT CORRESPONDENCE_PK;

ALTER TABLE ADR.CORRESPONDENCE ADD (
  CONSTRAINT CORRESPONDENCE_PK
  PRIMARY KEY
  (CORRESPONDENCE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CORRESPONDENCE
  DROP CONSTRAINT CORRESPONDENCE_PERSON_FK;


ALTER TABLE ADR.CORRESPONDENCE ADD (
  CONSTRAINT CORRESPONDENCE_PERSON_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CORRESPONDENCE_H
  DROP CONSTRAINT CORRESPONDENCE_H_PK;

ALTER TABLE ADR.CORRESPONDENCE_H ADD (
  CONSTRAINT CORRESPONDENCE_H_PK
  PRIMARY KEY
  (CORRESPONDENCE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CORRESPONDENCE
  DROP CONSTRAINT CORRESPONDENCE_EMAIL_TEMP_FK;


ALTER TABLE ADR.CORRESPONDENCE ADD (
  CONSTRAINT CORRESPONDENCE_EMAIL_TEMP_FK 
  FOREIGN KEY (EMAIL_TEMPLATE_ID) 
  REFERENCES ADR.COM_EMAIL_TEMPLATE (COM_EMAIL_TEMPLATE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CORRESPONDENCE
  DROP CONSTRAINT CORRESPONDENCE_EMAIL_H_FK;


ALTER TABLE ADR.CORRESPONDENCE ADD (
  CONSTRAINT CORRESPONDENCE_EMAIL_H_FK 
  FOREIGN KEY (EMAIL_H_ID) 
  REFERENCES ADR.EMAIL_H (EMAIL_H_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CORRESPONDENCE_DOCUMENT
  DROP CONSTRAINT CORRESPONDENCE_DOCUMENT_PK;

ALTER TABLE ADR.CORRESPONDENCE_DOCUMENT ADD (
  CONSTRAINT CORRESPONDENCE_DOCUMENT_PK
  PRIMARY KEY
  (CORRESPONDENCE_DOCUMENT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CORRESPONDENCE
  DROP CONSTRAINT CORRESPONDENCE_COM_LTR_TEMP_FK;


ALTER TABLE ADR.CORRESPONDENCE ADD (
  CONSTRAINT CORRESPONDENCE_COM_LTR_TEMP_FK 
  FOREIGN KEY (COM_LETTER_TEMPLATE_ID) 
  REFERENCES ADR.COM_LETTER_TEMPLATE (COM_LETTER_TEMPLATE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CORRESPONDENCE
  DROP CONSTRAINT CORRESPONDENCE_ADDR_H_FK;


ALTER TABLE ADR.CORRESPONDENCE ADD (
  CONSTRAINT CORRESPONDENCE_ADDR_H_FK 
  FOREIGN KEY (ADDRESS_H_ID) 
  REFERENCES ADR.ADDRESS_H (ADDRESS_H_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CONFLICT_DETAIL
  DROP CONSTRAINT CONFLDTL_PK;

ALTER TABLE ADR.CONFLICT_DETAIL ADD (
  CONSTRAINT CONFLDTL_PK
  PRIMARY KEY
  (CONFLICT_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CONFLICT_DETAIL
  DROP CONSTRAINT CONFLDTL_MILSRVC_FK;


ALTER TABLE ADR.CONFLICT_DETAIL ADD (
  CONSTRAINT CONFLDTL_MILSRVC_FK 
  FOREIGN KEY (MILITARY_SERVICE_ID) 
  REFERENCES ADR.MILITARY_SERVICE (MILITARY_SERVICE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CONFLICT_DETAIL_H
  DROP CONSTRAINT CONFLDTLH_PK;

ALTER TABLE ADR.CONFLICT_DETAIL_H ADD (
  CONSTRAINT CONFLDTLH_PK
  PRIMARY KEY
  (CONFLICT_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_TRANSMISSION_LOG
  DROP CONSTRAINT COMTRANLOG_PK;

ALTER TABLE ADR.COM_TRANSMISSION_LOG ADD (
  CONSTRAINT COMTRANLOG_PK
  PRIMARY KEY
  (COM_TRANSMISSION_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_HEC_REJECT_DETAIL
  DROP CONSTRAINT COMRJCTDTL_PK;

ALTER TABLE ADR.COM_HEC_REJECT_DETAIL ADD (
  CONSTRAINT COMRJCTDTL_PK
  PRIMARY KEY
  (COM_HEC_REJECT_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_HEC_REJECT_DETAIL
  DROP CONSTRAINT COMRJCTDTL_COMMAIL_FK;


ALTER TABLE ADR.COM_HEC_REJECT_DETAIL ADD (
  CONSTRAINT COMRJCTDTL_COMMAIL_FK 
  FOREIGN KEY (COM_MAILING_ID) 
  REFERENCES ADR.COM_MAILING (COM_MAILING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_PRINT_REQUEST
  DROP CONSTRAINT COMPRTREQ_U_PRINT_DUPLICATE_UK;

ALTER TABLE ADR.COM_PRINT_REQUEST ADD (
  CONSTRAINT COMPRTREQ_U_PRINT_DUPLICATE_UK
  UNIQUE (PRINT_REQUEST_UNIQUE_CODE)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_PRINT_REQUEST
  DROP CONSTRAINT COMPRTREQ_PK;

ALTER TABLE ADR.COM_PRINT_REQUEST ADD (
  CONSTRAINT COMPRTREQ_PK
  PRIMARY KEY
  (COM_PRINT_REQUEST_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_PRINT_REQUEST
  DROP CONSTRAINT COMPRTREQ_COMMAIL_FK;


ALTER TABLE ADR.COM_PRINT_REQUEST ADD (
  CONSTRAINT COMPRTREQ_COMMAIL_FK 
  FOREIGN KEY (COM_MAILING_ID) 
  REFERENCES ADR.COM_MAILING (COM_MAILING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_PRINT_CHECK
  DROP CONSTRAINT COMPRTCHK_PK;

ALTER TABLE ADR.COM_PRINT_CHECK ADD (
  CONSTRAINT COMPRTCHK_PK
  PRIMARY KEY
  (COM_PRINT_CHECK_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_PRINT_CHECK
  DROP CONSTRAINT COMPRTCHK_COMPRTREQ_FK;


ALTER TABLE ADR.COM_PRINT_CHECK ADD (
  CONSTRAINT COMPRTCHK_COMPRTREQ_FK 
  FOREIGN KEY (COM_PRINT_REQUEST_ID) 
  REFERENCES ADR.COM_PRINT_REQUEST (COM_PRINT_REQUEST_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_PRINT_CHECK
  DROP CONSTRAINT COMPRTCHK_COMMAIL_FK;


ALTER TABLE ADR.COM_PRINT_CHECK ADD (
  CONSTRAINT COMPRTCHK_COMMAIL_FK 
  FOREIGN KEY (COM_MAILING_ID) 
  REFERENCES ADR.COM_MAILING (COM_MAILING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_PRINT_CHECK
  DROP CONSTRAINT COMPRTCHK_COMCNLPR_FK;


ALTER TABLE ADR.COM_PRINT_CHECK ADD (
  CONSTRAINT COMPRTCHK_COMCNLPR_FK 
  FOREIGN KEY (COM_CANCELED_REQUEST_ID) 
  REFERENCES ADR.COM_CANCELED_REQUEST (COM_CANCELED_REQUEST_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_COMPLETED_REPORTS
  DROP CONSTRAINT COMPRPT_PK;

ALTER TABLE ADR.RPT_COMPLETED_REPORTS ADD (
  CONSTRAINT COMPRPT_PK
  PRIMARY KEY
  (RPT_COMPLETED_REPORT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL
  DROP CONSTRAINT COMMLSTAT_STD_COMAILSTAT_FK;


ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL ADD (
  CONSTRAINT COMMLSTAT_STD_COMAILSTAT_FK 
  FOREIGN KEY (COM_MAILING_STATUS_TYPE_ID) 
  REFERENCES ADRREF.STD_COMMMAILINGSTTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL
  DROP CONSTRAINT COMMLSTAT_PK;

ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL ADD (
  CONSTRAINT COMMLSTAT_PK
  PRIMARY KEY
  (COM_MAILING_STATUS_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL
  DROP CONSTRAINT COMMLSTAT_COMMAIL_FK;


ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL ADD (
  CONSTRAINT COMMLSTAT_COMMAIL_FK 
  FOREIGN KEY (COM_MAILING_ID) 
  REFERENCES ADR.COM_MAILING (COM_MAILING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_MAILING
  DROP CONSTRAINT COMMAIL_WKFCASE_FK;


ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT COMMAIL_WKFCASE_FK 
  FOREIGN KEY (WKF_CASE_ID) 
  REFERENCES ADR.WKF_CASE (WKF_CASE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_MAILING
  DROP CONSTRAINT COMMAIL_STD_COMRJCTRSN_FK;


ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT COMMAIL_STD_COMRJCTRSN_FK 
  FOREIGN KEY (COM_AAC_REJECT_REASON_TYPE_ID) 
  REFERENCES ADRREF.STD_COMREJECTREASONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_MAILING
  DROP CONSTRAINT COMMAIL_STD_COMMLTRG_FK;


ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT COMMAIL_STD_COMMLTRG_FK 
  FOREIGN KEY (COM_MAILING_TRIGGER_TYPE_ID) 
  REFERENCES ADRREF.STD_COMMMLTRIGGERTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_MAILING
  DROP CONSTRAINT COMMAIL_PRSN_FK;


ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT COMMAIL_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_MAILING
  DROP CONSTRAINT COMMAIL_PK;

ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT COMMAIL_PK
  PRIMARY KEY
  (COM_MAILING_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_MAILING
  DROP CONSTRAINT COMMAIL_COMLTRTPL_FK;


ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT COMMAIL_COMLTRTPL_FK 
  FOREIGN KEY (COM_LETTER_TEMPLATE_ID) 
  REFERENCES ADR.COM_LETTER_TEMPLATE (COM_LETTER_TEMPLATE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_MAILING
  DROP CONSTRAINT COMMAIL_COMLETTYPE_FK;


ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT COMMAIL_COMLETTYPE_FK 
  FOREIGN KEY (COM_LETTER_TYPE_ID) 
  REFERENCES ADRREF.STD_COMMLETTERTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_LETTER_TEMPLATE
  DROP CONSTRAINT COMLTRTPL_STD_COMLTRTYPE_FK;


ALTER TABLE ADR.COM_LETTER_TEMPLATE ADD (
  CONSTRAINT COMLTRTPL_STD_COMLTRTYPE_FK 
  FOREIGN KEY (COM_LETTER_TYPE_ID) 
  REFERENCES ADRREF.STD_COMMLETTERTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_LETTER_TEMPLATE
  DROP CONSTRAINT COMLTRTPL_STD_COMLTRGTYPE_FK;


ALTER TABLE ADR.COM_LETTER_TEMPLATE ADD (
  CONSTRAINT COMLTRTPL_STD_COMLTRGTYPE_FK 
  FOREIGN KEY (COM_LETTER_GENERATED_TYPE_ID) 
  REFERENCES ADRREF.STD_COMMLETTERGENTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_LETTER_TEMPLATE
  DROP CONSTRAINT COMLTRTPL_PK;

ALTER TABLE ADR.COM_LETTER_TEMPLATE ADD (
  CONSTRAINT COMLTRTPL_PK
  PRIMARY KEY
  (COM_LETTER_TEMPLATE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE
  DROP CONSTRAINT COMLOG_PK;

ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE ADD (
  CONSTRAINT COMLOG_PK
  PRIMARY KEY
  (HANDBOOK_MAIL_QUEUE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_FORM_STATISTICS
  DROP CONSTRAINT COMFRMSTAT_PK;

ALTER TABLE ADR.COM_FORM_STATISTICS ADD (
  CONSTRAINT COMFRMSTAT_PK
  PRIMARY KEY
  (COM_FORM_STATISTICS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_FORM_STATISTICS
  DROP CONSTRAINT COMFRMSTAT_COMTRANLOG_FK;


ALTER TABLE ADR.COM_FORM_STATISTICS ADD (
  CONSTRAINT COMFRMSTAT_COMTRANLOG_FK 
  FOREIGN KEY (COM_TRANSMISSION_LOG_ID) 
  REFERENCES ADR.COM_TRANSMISSION_LOG (COM_TRANSMISSION_LOG_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_EMAIL_TEMPLATE
  DROP CONSTRAINT COMEMLTPL_PK;

ALTER TABLE ADR.COM_EMAIL_TEMPLATE ADD (
  CONSTRAINT COMEMLTPL_PK
  PRIMARY KEY
  (COM_EMAIL_TEMPLATE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_CANCELED_REQUEST
  DROP CONSTRAINT COMCNLPR_PK;

ALTER TABLE ADR.COM_CANCELED_REQUEST ADD (
  CONSTRAINT COMCNLPR_PK
  PRIMARY KEY
  (COM_CANCELED_REQUEST_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_CANCELED_REQUEST
  DROP CONSTRAINT COMCNLPR_COMMAIL_FK;


ALTER TABLE ADR.COM_CANCELED_REQUEST ADD (
  CONSTRAINT COMCNLPR_COMMAIL_FK 
  FOREIGN KEY (COM_MAILING_ID) 
  REFERENCES ADR.COM_MAILING (COM_MAILING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_AAC_ERROR_DETAIL
  DROP CONSTRAINT COMAACERR_STD_COMERRTYP_FK;


ALTER TABLE ADR.COM_AAC_ERROR_DETAIL ADD (
  CONSTRAINT COMAACERR_STD_COMERRTYP_FK 
  FOREIGN KEY (COM_AAC_ERROR_TYPE_ID) 
  REFERENCES ADRREF.STD_COMMERRORTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_AAC_ERROR_DETAIL
  DROP CONSTRAINT COMAACERR_PK;

ALTER TABLE ADR.COM_AAC_ERROR_DETAIL ADD (
  CONSTRAINT COMAACERR_PK
  PRIMARY KEY
  (COM_AAC_ERROR_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_AAC_ERROR_DETAIL
  DROP CONSTRAINT COMAACERR_COMMAIL_FK;


ALTER TABLE ADR.COM_AAC_ERROR_DETAIL ADD (
  CONSTRAINT COMAACERR_COMMAIL_FK 
  FOREIGN KEY (COM_MAILING_ID) 
  REFERENCES ADR.COM_MAILING (COM_MAILING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.TRANSMISSION_TYPE
  DROP CONSTRAINT CODE_UK;

ALTER TABLE ADR.TRANSMISSION_TYPE ADD (
  CONSTRAINT CODE_UK
  UNIQUE (CODE)
  ENABLE VALIDATE);
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY
  DROP CONSTRAINT CNFADDR_PRSN_FK;


ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY ADD (
  CONSTRAINT CNFADDR_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY
  DROP CONSTRAINT CNFADDR_PK;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY ADD (
  CONSTRAINT CNFADDR_PK
  PRIMARY KEY
  (CONFIDENTIAL_ADDR_CATGRY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H
  DROP CONSTRAINT CNFADDRH_PK;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H ADD (
  CONSTRAINT CNFADDRH_PK
  PRIMARY KEY
  (CONFIDENTIAL_ADDR_CATGRY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_COMPLETED_REPORTS
  DROP CONSTRAINT CMRPT_STD_RPTSTDRPT_FK;


ALTER TABLE ADR.RPT_COMPLETED_REPORTS ADD (
  CONSTRAINT CMRPT_STD_RPTSTDRPT_FK 
  FOREIGN KEY (RPT_STANDARD_REPORT_ID) 
  REFERENCES ADRREF.STD_RPTSTANDARDREPORTS (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_COMPLETED_REPORTS
  DROP CONSTRAINT CMRPT_STD_RPTOUTFILE_FK;


ALTER TABLE ADR.RPT_COMPLETED_REPORTS ADD (
  CONSTRAINT CMRPT_STD_RPTOUTFILE_FK 
  FOREIGN KEY (RPT_OUTPUT_FILE_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTOUTPUTFILETYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_COMPLETED_REPORTS
  DROP CONSTRAINT CMPRPT_USER_1_FK;


ALTER TABLE ADR.RPT_COMPLETED_REPORTS ADD (
  CONSTRAINT CMPRPT_USER_1_FK 
  FOREIGN KEY (USERID) 
  REFERENCES ADR.USERS (USERID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.COMBAT_PAY
  DROP CONSTRAINT CMBTPAY_PRSN_FK;


ALTER TABLE ADR.COMBAT_PAY ADD (
  CONSTRAINT CMBTPAY_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COMBAT_PAY
  DROP CONSTRAINT CMBTPAY_PK;

ALTER TABLE ADR.COMBAT_PAY ADD (
  CONSTRAINT CMBTPAY_PK
  PRIMARY KEY
  (COMBAT_PAY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COMBAT_PAY_H
  DROP CONSTRAINT CMBTPAYH_PK;

ALTER TABLE ADR.COMBAT_PAY_H ADD (
  CONSTRAINT CMBTPAYH_PK
  PRIMARY KEY
  (COMBAT_PAY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COMBAT_EPISODE
  DROP CONSTRAINT CMBTEPSD_PRSN_FK;


ALTER TABLE ADR.COMBAT_EPISODE ADD (
  CONSTRAINT CMBTEPSD_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COMBAT_EPISODE
  DROP CONSTRAINT CMBTEPSD_PK;

ALTER TABLE ADR.COMBAT_EPISODE ADD (
  CONSTRAINT CMBTEPSD_PK
  PRIMARY KEY
  (COMBAT_EPISODE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COMBAT_EPISODE_H
  DROP CONSTRAINT CMBTEPSDH_PK;

ALTER TABLE ADR.COMBAT_EPISODE_H ADD (
  CONSTRAINT CMBTEPSDH_PK
  PRIMARY KEY
  (COMBAT_EPISODE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CL_VERIFICATION_METHOD
  DROP CONSTRAINT CL_VERIFICATION_METHOD_PK;

ALTER TABLE ADR.CL_VERIFICATION_METHOD ADD (
  CONSTRAINT CL_VERIFICATION_METHOD_PK
  PRIMARY KEY
  (CL_VERIFICATION_METHOD_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CL_VERIFICATION_METHOD_H
  DROP CONSTRAINT CL_VERIFICATION_METHOD_H_PK;

ALTER TABLE ADR.CL_VERIFICATION_METHOD_H ADD (
  CONSTRAINT CL_VERIFICATION_METHOD_H_PK
  PRIMARY KEY
  (CL_VERIFICATION_METHOD_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CLOSE_APL_RSN_TYPE
  DROP CONSTRAINT CLOSE_APL_RSN_TYPE_PK;

ALTER TABLE ADR.CLOSE_APL_RSN_TYPE ADD (
  CONSTRAINT CLOSE_APL_RSN_TYPE_PK
  PRIMARY KEY
  (CLOSE_APL_RSN_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION
  DROP CONSTRAINT CLOSE_APL_RSN_TYPE_ID_FK;


ALTER TABLE ADR.ENROLLMENT_DETERMINATION ADD (
  CONSTRAINT CLOSE_APL_RSN_TYPE_ID_FK 
  FOREIGN KEY (CLOSE_APL_RSN_TYPE_ID) 
  REFERENCES ADR.CLOSE_APL_RSN_TYPE (CLOSE_APL_RSN_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CI_TRANSACTION_LOG
  DROP CONSTRAINT CI_TRANSACTION_LOG_PK;

ALTER TABLE ADR.CI_TRANSACTION_LOG ADD (
  CONSTRAINT CI_TRANSACTION_LOG_PK
  PRIMARY KEY
  (CI_TRANSACTION_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CI_TRANSACTION_LOG
  DROP CONSTRAINT CI_TRANSACTION_LOG_CHK;

ALTER TABLE ADR.CI_TRANSACTION_LOG ADD (
  CONSTRAINT CI_TRANSACTION_LOG_CHK
  CHECK (ENTITY_TYPE IN ('Address', 'Email', 'Phone'))
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_REGION_STATE
  DROP CONSTRAINT CCN_REGION_STATE_PK;

ALTER TABLE ADR.CCN_REGION_STATE ADD (
  CONSTRAINT CCN_REGION_STATE_PK
  PRIMARY KEY
  (CCN_REGION_STATE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_REGION
  DROP CONSTRAINT CCN_REGION_PK;

ALTER TABLE ADR.CCN_REGION ADD (
  CONSTRAINT CCN_REGION_PK
  PRIMARY KEY
  (CCN_REGION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_CONTRACTOR_REGION
  DROP CONSTRAINT CCN_REGION_ID_FK;


ALTER TABLE ADR.CCN_CONTRACTOR_REGION ADD (
  CONSTRAINT CCN_REGION_ID_FK 
  FOREIGN KEY (CCN_REGION_ID) 
  REFERENCES ADR.CCN_REGION (CCN_REGION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG
  DROP CONSTRAINT CCN_RECEIVED_SERVICE_LOG_PK;

ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG ADD (
  CONSTRAINT CCN_RECEIVED_SERVICE_LOG_PK
  PRIMARY KEY
  (CCN_RECEIVED_SERVICE_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_FILETRANSFER
  DROP CONSTRAINT CCN_FILETRANS_ID_PK;

ALTER TABLE ADR.CCN_FILETRANSFER ADD (
  CONSTRAINT CCN_FILETRANS_ID_PK
  PRIMARY KEY
  (CCN_FILETRANSFER_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_DATALOAD_LOG_STG
  DROP CONSTRAINT CCN_DATALOAD_STAT_CONS;

ALTER TABLE ADR.CCN_DATALOAD_LOG_STG ADD (
  CONSTRAINT CCN_DATALOAD_STAT_CONS
  CHECK ( STATUS IN ('STARTED','COMPLETED'))
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_DAS_RESPONSE
  DROP CONSTRAINT CCN_DAS_RESP_STATUS_FK;


ALTER TABLE ADR.CCN_DAS_RESPONSE ADD (
  CONSTRAINT CCN_DAS_RESP_STATUS_FK 
  FOREIGN KEY (VCADMISTATUS_TYPE_ID) 
  REFERENCES ADR.VCADMISTATUS_TYPE (VCADMISTATUS_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_DAS_RESPONSE
  DROP CONSTRAINT CCN_DAS_RESP_ID_PK;

ALTER TABLE ADR.CCN_DAS_RESPONSE ADD (
  CONSTRAINT CCN_DAS_RESP_ID_PK
  PRIMARY KEY
  (CCN_DAS_RESPONSE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_DAS_RESPONSE
  DROP CONSTRAINT CCN_DAS_RESP_FILE_ID_FK;


ALTER TABLE ADR.CCN_DAS_RESPONSE ADD (
  CONSTRAINT CCN_DAS_RESP_FILE_ID_FK 
  FOREIGN KEY (CCN_FILETRANSFER_ID) 
  REFERENCES ADR.CCN_FILETRANSFER (CCN_FILETRANSFER_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_DAS_RESPONSE
  DROP CONSTRAINT CCN_DAS_RESP_CONTRACTOR_ID_FK;


ALTER TABLE ADR.CCN_DAS_RESPONSE ADD (
  CONSTRAINT CCN_DAS_RESP_CONTRACTOR_ID_FK 
  FOREIGN KEY (CCN_CONTRACTOR_ID) 
  REFERENCES ADR.CCN_CONTRACTOR (CCN_CONTRACTOR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_CONTRACTOR_REGION
  DROP CONSTRAINT CCN_CONTRACTOR_REGION_PK;

ALTER TABLE ADR.CCN_CONTRACTOR_REGION ADD (
  CONSTRAINT CCN_CONTRACTOR_REGION_PK
  PRIMARY KEY
  (CCN_CONTRACTOR_REGION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_CONTRACTOR_REGION_H
  DROP CONSTRAINT CCN_CONTRACTOR_REGION_H_PK;

ALTER TABLE ADR.CCN_CONTRACTOR_REGION_H ADD (
  CONSTRAINT CCN_CONTRACTOR_REGION_H_PK
  PRIMARY KEY
  (CCN_CONTRACTOR_REGION_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_CONTRACTOR
  DROP CONSTRAINT CCN_CONTRACTOR_PK;

ALTER TABLE ADR.CCN_CONTRACTOR ADD (
  CONSTRAINT CCN_CONTRACTOR_PK
  PRIMARY KEY
  (CCN_CONTRACTOR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_CONTRACTOR_REGION
  DROP CONSTRAINT CCN_CONTRACTOR_ID_FK;


ALTER TABLE ADR.CCN_CONTRACTOR_REGION ADD (
  CONSTRAINT CCN_CONTRACTOR_ID_FK 
  FOREIGN KEY (CCN_CONTRACTOR_ID) 
  REFERENCES ADR.CCN_CONTRACTOR (CCN_CONTRACTOR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_CONTRACTOR_H
  DROP CONSTRAINT CCN_CONTRACTOR_H_PK;

ALTER TABLE ADR.CCN_CONTRACTOR_H ADD (
  CONSTRAINT CCN_CONTRACTOR_H_PK
  PRIMARY KEY
  (CCN_CONTRACTOR_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_SERVICE_LOG
  DROP CONSTRAINT CCNSVCLOG_CCNFLTR_ID_FK;


ALTER TABLE ADR.CCN_SERVICE_LOG ADD (
  CONSTRAINT CCNSVCLOG_CCNFLTR_ID_FK 
  FOREIGN KEY (CCN_FILETRANSFER_ID) 
  REFERENCES ADR.CCN_FILETRANSFER (CCN_FILETRANSFER_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_SERVICE_LOG
  DROP CONSTRAINT CCNSERVLOG_VCELIGBTY_H_ID_FK;


ALTER TABLE ADR.CCN_SERVICE_LOG ADD (
  CONSTRAINT CCNSERVLOG_VCELIGBTY_H_ID_FK 
  FOREIGN KEY (VCELIGIBILITY_H_ID) 
  REFERENCES ADR.VCELIGIBILITY_H (VCELIGIBILITY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_SERVICE_LOG
  DROP CONSTRAINT CCNSERVLOG_TRANSTYPE_ID_FK;


ALTER TABLE ADR.CCN_SERVICE_LOG ADD (
  CONSTRAINT CCNSERVLOG_TRANSTYPE_ID_FK 
  FOREIGN KEY (TRANSMISSION_TYPE_ID) 
  REFERENCES ADR.TRANSMISSION_TYPE (TRANSMISSION_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_SERVICE_LOG
  DROP CONSTRAINT CCNSERVLOG_TRANSTASTTYPEID_FK;


ALTER TABLE ADR.CCN_SERVICE_LOG ADD (
  CONSTRAINT CCNSERVLOG_TRANSTASTTYPEID_FK 
  FOREIGN KEY (TRANSMISSION_STTYPE_ID) 
  REFERENCES ADR.VCADMISTATUS_TYPE (VCADMISTATUS_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_SERVICE_LOG
  DROP CONSTRAINT CCNSERVLOG_RESADRHID_FK;


ALTER TABLE ADR.CCN_SERVICE_LOG ADD (
  CONSTRAINT CCNSERVLOG_RESADRHID_FK 
  FOREIGN KEY (RESI_ADDRESS_H_ID) 
  REFERENCES ADR.ADDRESS_H (ADDRESS_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_SERVICE_LOG
  DROP CONSTRAINT CCNSERVLOG_PFFACHID_FK;


ALTER TABLE ADR.CCN_SERVICE_LOG ADD (
  CONSTRAINT CCNSERVLOG_PFFACHID_FK 
  FOREIGN KEY (PREFERRED_FACILITY_H_ID) 
  REFERENCES ADR.PREFERRED_FACILITY_H (PREFERRED_FACILITY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_SERVICE_LOG
  DROP CONSTRAINT CCNSERVLOG_PERSON_ID_FK;


ALTER TABLE ADR.CCN_SERVICE_LOG ADD (
  CONSTRAINT CCNSERVLOG_PERSON_ID_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_SERVICE_LOG
  DROP CONSTRAINT CCNSERVLOG_MAILADDRHID_FK;


ALTER TABLE ADR.CCN_SERVICE_LOG ADD (
  CONSTRAINT CCNSERVLOG_MAILADDRHID_FK 
  FOREIGN KEY (MAILING_ADDRESS_H_ID) 
  REFERENCES ADR.ADDRESS_H (ADDRESS_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_SERVICE_LOG
  DROP CONSTRAINT CCNSERVLOG_GEOCODE_STATION_FK;


ALTER TABLE ADR.CCN_SERVICE_LOG ADD (
  CONSTRAINT CCNSERVLOG_GEOCODE_STATION_FK 
  FOREIGN KEY (GEOCODE_STATION_H_ID) 
  REFERENCES ADR.GEOCODE_STATION_H (GEOCODE_STATION_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_SERVICE_LOG
  DROP CONSTRAINT CCNSERVLOG_CCNSERVLOG_ID_PK;

ALTER TABLE ADR.CCN_SERVICE_LOG ADD (
  CONSTRAINT CCNSERVLOG_CCNSERVLOG_ID_PK
  PRIMARY KEY
  (CCN_SERVICE_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_REGION_STATE
  DROP CONSTRAINT CCNRSNSTA_REGION_ID_FK;


ALTER TABLE ADR.CCN_REGION_STATE ADD (
  CONSTRAINT CCNRSNSTA_REGION_ID_FK 
  FOREIGN KEY (CCN_REGION_ID) 
  REFERENCES ADR.CCN_REGION (CCN_REGION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG
  DROP CONSTRAINT CCNRSERVLOG_VCADMNSTATPID_FK;


ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG ADD (
  CONSTRAINT CCNRSERVLOG_VCADMNSTATPID_FK 
  FOREIGN KEY (VCADMINSTATUS_TYPE_ID) 
  REFERENCES ADR.VCADMISTATUS_TYPE (VCADMISTATUS_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG
  DROP CONSTRAINT CCNRSERVLOG_PERSONID_FK;


ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG ADD (
  CONSTRAINT CCNRSERVLOG_PERSONID_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG
  DROP CONSTRAINT CCNRSERVLOG_CONTRACTORID_FK;


ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG ADD (
  CONSTRAINT CCNRSERVLOG_CONTRACTORID_FK 
  FOREIGN KEY (CCN_CONTRACTOR_ID) 
  REFERENCES ADR.CCN_CONTRACTOR (CCN_CONTRACTOR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_FILETRANSFER
  DROP CONSTRAINT CCNFITRANSF_VCADSTPIDD_FK_I;


ALTER TABLE ADR.CCN_FILETRANSFER ADD (
  CONSTRAINT CCNFITRANSF_VCADSTPIDD_FK_I 
  FOREIGN KEY (VCADMISTATUS_TYPE_ID) 
  REFERENCES ADR.VCADMISTATUS_TYPE (VCADMISTATUS_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_FILETRANSFER
  DROP CONSTRAINT CCNFITRANSFER_TRNSTYPEID_FK;


ALTER TABLE ADR.CCN_FILETRANSFER ADD (
  CONSTRAINT CCNFITRANSFER_TRNSTYPEID_FK 
  FOREIGN KEY (TRANSMISSION_TYPE_ID) 
  REFERENCES ADR.TRANSMISSION_TYPE (TRANSMISSION_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_FILETRANSFER_H
  DROP CONSTRAINT CCNFILETRANSHID_PK;

ALTER TABLE ADR.CCN_FILETRANSFER_H ADD (
  CONSTRAINT CCNFILETRANSHID_PK
  PRIMARY KEY
  (CCN_FILETRANSFER_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR
  DROP CONSTRAINT CAT_DSBLTY_DESCRIPTOR_PK;

ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR ADD (
  CONSTRAINT CAT_DSBLTY_DESCRIPTOR_PK
  PRIMARY KEY
  (CAT_DSBLTY_DESCRIPTOR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H
  DROP CONSTRAINT CAT_DSBLTY_DESCRIPTOR_H_PK;

ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H ADD (
  CONSTRAINT CAT_DSBLTY_DESCRIPTOR_H_PK
  PRIMARY KEY
  (CAT_DSBLTY_DESCRIPTOR_ID_H)
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR
  DROP CONSTRAINT CAT_DSBLTY_CAT_DSBLTY_DESC_FK;


ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR ADD (
  CONSTRAINT CAT_DSBLTY_CAT_DSBLTY_DESC_FK 
  FOREIGN KEY (CATASTROPHIC_DISABILITY_ID) 
  REFERENCES ADR.CATASTROPHIC_DISABILITY (CATASTROPHIC_DISABILITY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS
  DROP CONSTRAINT CATDSDIAG_PK;

ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS ADD (
  CONSTRAINT CATDSDIAG_PK
  PRIMARY KEY
  (CAT_DSBLTY_DIAGNOSIS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS
  DROP CONSTRAINT CATDSDIAG_CATDSBLTY_FK;


ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS ADD (
  CONSTRAINT CATDSDIAG_CATDSBLTY_FK 
  FOREIGN KEY (CATASTROPHIC_DISABILITY_ID) 
  REFERENCES ADR.CATASTROPHIC_DISABILITY (CATASTROPHIC_DISABILITY_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H
  DROP CONSTRAINT CATDSDIAGH_PK;

ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H ADD (
  CONSTRAINT CATDSDIAGH_PK
  PRIMARY KEY
  (CAT_DSBLTY_DIAGNOSIS_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_CONDITION
  DROP CONSTRAINT CATDSCOND_PK;

ALTER TABLE ADR.CAT_DSBLTY_CONDITION ADD (
  CONSTRAINT CATDSCOND_PK
  PRIMARY KEY
  (CAT_DSBLTY_CONDITION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_CONDITION
  DROP CONSTRAINT CATDSCOND_CATDSBLTY_FK;


ALTER TABLE ADR.CAT_DSBLTY_CONDITION ADD (
  CONSTRAINT CATDSCOND_CATDSBLTY_FK 
  FOREIGN KEY (CATASTROPHIC_DISABILITY_ID) 
  REFERENCES ADR.CATASTROPHIC_DISABILITY (CATASTROPHIC_DISABILITY_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H
  DROP CONSTRAINT CATDSCONDH_PK;

ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H ADD (
  CONSTRAINT CATDSCONDH_PK
  PRIMARY KEY
  (CAT_DSBLTY_CONDITION_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CATASTROPHIC_DISABILITY
  DROP CONSTRAINT CATDSBLTY_PRSN_FK;


ALTER TABLE ADR.CATASTROPHIC_DISABILITY ADD (
  CONSTRAINT CATDSBLTY_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CATASTROPHIC_DISABILITY
  DROP CONSTRAINT CATDSBLTY_PK;

ALTER TABLE ADR.CATASTROPHIC_DISABILITY ADD (
  CONSTRAINT CATDSBLTY_PK
  PRIMARY KEY
  (CATASTROPHIC_DISABILITY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H
  DROP CONSTRAINT CATDSBLTYH_PK;

ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H ADD (
  CONSTRAINT CATDSBLTYH_PK
  PRIMARY KEY
  (CATASTROPHIC_DISABILITY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H
  DROP CONSTRAINT CATDSBLPRH_PK;

ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H ADD (
  CONSTRAINT CATDSBLPRH_PK
  PRIMARY KEY
  (CAT_DSBLTY_PROCEDURE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE
  DROP CONSTRAINT CATDSBLPRC_PK;

ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE ADD (
  CONSTRAINT CATDSBLPRC_PK
  PRIMARY KEY
  (CAT_DSBLTY_PROCEDURE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE
  DROP CONSTRAINT CATDSBLPRC_CATDSBLTY_FK;


ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE ADD (
  CONSTRAINT CATDSBLPRC_CATDSBLTY_FK 
  FOREIGN KEY (CATASTROPHIC_DISABILITY_ID) 
  REFERENCES ADR.CATASTROPHIC_DISABILITY (CATASTROPHIC_DISABILITY_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.CASSCERTIFIEDTYPE
  DROP CONSTRAINT CASSCERTIFIEDTYPE_PK;

ALTER TABLE ADR.CASSCERTIFIEDTYPE ADD (
  CONSTRAINT CASSCERTIFIEDTYPE_PK
  PRIMARY KEY
  (CASSCERTIFIEDTYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CANCEL_DECLINE
  DROP CONSTRAINT CANDEC_PRSN_FK;


ALTER TABLE ADR.CANCEL_DECLINE ADD (
  CONSTRAINT CANDEC_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CANCEL_DECLINE
  DROP CONSTRAINT CANDEC_PK;

ALTER TABLE ADR.CANCEL_DECLINE ADD (
  CONSTRAINT CANDEC_PK
  PRIMARY KEY
  (CANCEL_DECLINE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CANCEL_DECLINE_H
  DROP CONSTRAINT CANDECH_PK;

ALTER TABLE ADR.CANCEL_DECLINE_H ADD (
  CONSTRAINT CANDECH_PK
  PRIMARY KEY
  (CANCEL_DECLINE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP
  DROP CONSTRAINT BTCREQPRRGRP_PK;

ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP ADD (
  CONSTRAINT BTCREQPRRGRP_PK
  PRIMARY KEY
  (BATCH_REQUEST_PRIORITY_GRP_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BROKER_SERVICE_LOG
  DROP CONSTRAINT BRSRVPL_RETMNT_FK;


ALTER TABLE ADR.BROKER_SERVICE_LOG ADD (
  CONSTRAINT BRSRVPL_RETMNT_FK 
  FOREIGN KEY (RETIREMNT_RES_STAT_TYPE_ID) 
  REFERENCES ADR.LOOKUP_TYPE (LOOKUP_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BROKER_SERVICE_LOG
  DROP CONSTRAINT BRSRVPL_RES_FK;


ALTER TABLE ADR.BROKER_SERVICE_LOG ADD (
  CONSTRAINT BRSRVPL_RES_FK 
  FOREIGN KEY (DEPLOY_RES_STAT_TYPE_ID) 
  REFERENCES ADR.LOOKUP_TYPE (LOOKUP_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BROKER_SERVICE_PAYLOAD
  DROP CONSTRAINT BRSRVPL_PK;

ALTER TABLE ADR.BROKER_SERVICE_PAYLOAD ADD (
  CONSTRAINT BRSRVPL_PK
  PRIMARY KEY
  (BROKER_SERVICE_PAYLOAD_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BROKER_SERVICE_LOG
  DROP CONSTRAINT BRSRVPL_ELGBTY_FK;


ALTER TABLE ADR.BROKER_SERVICE_LOG ADD (
  CONSTRAINT BRSRVPL_ELGBTY_FK 
  FOREIGN KEY (ELGBTY_RES_STAT_TYPE_ID) 
  REFERENCES ADR.LOOKUP_TYPE (LOOKUP_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BROKER_SERVICE_LOG
  DROP CONSTRAINT BRSRVPL_DSBLTY_FK;


ALTER TABLE ADR.BROKER_SERVICE_LOG ADD (
  CONSTRAINT BRSRVPL_DSBLTY_FK 
  FOREIGN KEY (DISBLTY_RES_STAT_TYPE_ID) 
  REFERENCES ADR.LOOKUP_TYPE (LOOKUP_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BROKER_SERVICE_LOG
  DROP CONSTRAINT BRSRVL1_PK;

ALTER TABLE ADR.BROKER_SERVICE_LOG ADD (
  CONSTRAINT BRSRVL1_PK
  PRIMARY KEY
  (BROKER_SERVICE_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BROKER_SERVICE_ERROR
  DROP CONSTRAINT BRSRVER_PK;

ALTER TABLE ADR.BROKER_SERVICE_ERROR ADD (
  CONSTRAINT BRSRVER_PK
  PRIMARY KEY
  (BROKER_SERVICE_ERROR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BROKER_SERVICE_LOG
  DROP CONSTRAINT BRSL_TRANSTYP_FK;


ALTER TABLE ADR.BROKER_SERVICE_LOG ADD (
  CONSTRAINT BRSL_TRANSTYP_FK 
  FOREIGN KEY (TRANSMISSION_TYPE_ID) 
  REFERENCES ADR.TRANSMISSION_TYPE (TRANSMISSION_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BROKER_SERVICE_LOG
  DROP CONSTRAINT BRSL_PER_FK;


ALTER TABLE ADR.BROKER_SERVICE_LOG ADD (
  CONSTRAINT BRSL_PER_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DISABLE NOVALIDATE);
ALTER TABLE ADR.BROKER_SERVICE_LOG
  DROP CONSTRAINT BRSL_BRSE_FK;


ALTER TABLE ADR.BROKER_SERVICE_LOG ADD (
  CONSTRAINT BRSL_BRSE_FK 
  FOREIGN KEY (BROKER_SERVICE_ERROR_ID) 
  REFERENCES ADR.BROKER_SERVICE_ERROR (BROKER_SERVICE_ERROR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BENEFICIARY_SCI
  DROP CONSTRAINT BNFYSCI_PRSN_FK;


ALTER TABLE ADR.BENEFICIARY_SCI ADD (
  CONSTRAINT BNFYSCI_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_SCI
  DROP CONSTRAINT BNFYSCI_PK;

ALTER TABLE ADR.BENEFICIARY_SCI ADD (
  CONSTRAINT BNFYSCI_PK
  PRIMARY KEY
  (BENEFICIARY_SCI_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BENEFICIARY_SCI_H
  DROP CONSTRAINT BNFYSCIH_PK;

ALTER TABLE ADR.BENEFICIARY_SCI_H ADD (
  CONSTRAINT BNFYSCIH_PK
  PRIMARY KEY
  (BENEFICIARY_SCI_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BENEFICIARY_NTR
  DROP CONSTRAINT BNFYNTR_PRSN_FK;


ALTER TABLE ADR.BENEFICIARY_NTR ADD (
  CONSTRAINT BNFYNTR_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_NTR
  DROP CONSTRAINT BNFYNTR_PK;

ALTER TABLE ADR.BENEFICIARY_NTR ADD (
  CONSTRAINT BNFYNTR_PK
  PRIMARY KEY
  (BENEFICIARY_NTR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BENEFICIARY_NTR_H
  DROP CONSTRAINT BNFYNTRH_PK;

ALTER TABLE ADR.BENEFICIARY_NTR_H ADD (
  CONSTRAINT BNFYNTRH_PK
  PRIMARY KEY
  (BENEFICIARY_NTR_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BENEFICIARY_MST
  DROP CONSTRAINT BNFYMST_PRSN_FK;


ALTER TABLE ADR.BENEFICIARY_MST ADD (
  CONSTRAINT BNFYMST_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_MST
  DROP CONSTRAINT BNFYMST_PK;

ALTER TABLE ADR.BENEFICIARY_MST ADD (
  CONSTRAINT BNFYMST_PK
  PRIMARY KEY
  (BENEFICIARY_MST_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BENEFICIARY_MST_H
  DROP CONSTRAINT BNFYMSTH_PK;

ALTER TABLE ADR.BENEFICIARY_MST_H ADD (
  CONSTRAINT BNFYMSTH_PK
  PRIMARY KEY
  (BENEFICIARY_MST_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY
  DROP CONSTRAINT BENVISSUM_PRSN_FK;


ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY ADD (
  CONSTRAINT BENVISSUM_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY
  DROP CONSTRAINT BENVISSUM_PK;

ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY ADD (
  CONSTRAINT BENVISSUM_PK
  PRIMARY KEY
  (BENEFICIARY_VISIT_SUMMARY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H
  DROP CONSTRAINT BENVISSUMH_PK;

ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H ADD (
  CONSTRAINT BENVISSUMH_PK
  PRIMARY KEY
  (BENEFICIARY_VISIT_SUMMARY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BENEFICIARY_TRAVEL
  DROP CONSTRAINT BENTRVL_PRSN_FK;


ALTER TABLE ADR.BENEFICIARY_TRAVEL ADD (
  CONSTRAINT BENTRVL_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_TRAVEL
  DROP CONSTRAINT BENTRVL_PK;

ALTER TABLE ADR.BENEFICIARY_TRAVEL ADD (
  CONSTRAINT BENTRVL_PK
  PRIMARY KEY
  (BENEFICIARY_TRAVEL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BENEFICIARY_TRAVEL_H
  DROP CONSTRAINT BENTRVLH_PK;

ALTER TABLE ADR.BENEFICIARY_TRAVEL_H ADD (
  CONSTRAINT BENTRVLH_PK
  PRIMARY KEY
  (BENEFICIARY_TRAVEL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BENEFICIARY_SCI_H
  DROP CONSTRAINT BENEFICIARY_SCI_H_CHK;

ALTER TABLE ADR.BENEFICIARY_SCI_H ADD (
  CONSTRAINT BENEFICIARY_SCI_H_CHK
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN
  DROP CONSTRAINT BATREQVET_PK;

ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN ADD (
  CONSTRAINT BATREQVET_PK
  PRIMARY KEY
  (HANDBOOK_REQUEST_VETERAN_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H
  DROP CONSTRAINT BATREQPRRGRPH_PK;

ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H ADD (
  CONSTRAINT BATREQPRRGRPH_PK
  PRIMARY KEY
  (BATCH_REQUEST_PRI_GRP_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BATCH_REQUEST_FACILITY
  DROP CONSTRAINT BATREQFAC_PK;

ALTER TABLE ADR.BATCH_REQUEST_FACILITY ADD (
  CONSTRAINT BATREQFAC_PK
  PRIMARY KEY
  (BATCH_REQUEST_FACILITY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H
  DROP CONSTRAINT BATREQFACH_PK;

ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H ADD (
  CONSTRAINT BATREQFACH_PK
  PRIMARY KEY
  (BATCH_REQUEST_FACILITY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.DEPLOYMENT_H
  DROP CONSTRAINT AVCON_1253310191_TRANS_000;

ALTER TABLE ADR.DEPLOYMENT_H ADD (
  CONSTRAINT AVCON_1253310191_TRANS_000
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.MEDAL_OF_HONOR_H
  DROP CONSTRAINT AVCON_1252960469_TRANS_002;

ALTER TABLE ADR.MEDAL_OF_HONOR_H ADD (
  CONSTRAINT AVCON_1252960469_TRANS_002
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.ACTIVATION_H
  DROP CONSTRAINT AVCON_1252960469_TRANS_001;

ALTER TABLE ADR.ACTIVATION_H ADD (
  CONSTRAINT AVCON_1252960469_TRANS_001
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.SERVICE_CONNECTED_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_077;

ALTER TABLE ADR.SERVICE_CONNECTED_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_077
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_076;

ALTER TABLE ADR.EMAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_076
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_075;

ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_075
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_074;

ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_074
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_073;

ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_073
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.SIGNATURE_IMAGE_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_072;

ALTER TABLE ADR.SIGNATURE_IMAGE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_072
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.PH_REGISTRY_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_071;

ALTER TABLE ADR.PH_REGISTRY_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_071
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_070;

ALTER TABLE ADR.FINANCIAL_STATEMENT_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_070
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_NTR_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_069;

ALTER TABLE ADR.BENEFICIARY_NTR_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_069
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.WKF_CASE_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_068;

ALTER TABLE ADR.WKF_CASE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_068
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_COMMENTS_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_067;

ALTER TABLE ADR.WKF_CASE_COMMENTS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_067
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_066;

ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_066
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_065;

ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_065
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.PHONE_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_064;

ALTER TABLE ADR.PHONE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_064
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_063;

ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_063
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.ADDRESS_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_062;

ALTER TABLE ADR.ADDRESS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_062
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_061;

ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_061
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ROLE_PERMISSION_SETS_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_060;

ALTER TABLE ADR.ROLE_PERMISSION_SETS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_060
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.MEDICAID_FACTOR_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_059;

ALTER TABLE ADR.MEDICAID_FACTOR_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_059
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_058;

ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_058
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CANCEL_DECLINE_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_057;

ALTER TABLE ADR.CANCEL_DECLINE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_057
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.SHAD_REGISTRY_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_056;

ALTER TABLE ADR.SHAD_REGISTRY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_056
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_055;

ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_055
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_054;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_054
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_053;

ALTER TABLE ADR.INCOME_TEST_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_053
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_052;

ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_052
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_SITE_STATISTICS_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_051;

ALTER TABLE ADR.EGT_SITE_STATISTICS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_051
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLES_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_050;

ALTER TABLE ADR.ROLES_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_050
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_049;

ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_049
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLE_PERMISSIONS_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_048;

ALTER TABLE ADR.ROLE_PERMISSIONS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_048
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_047;

ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_047
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_046;

ALTER TABLE ADR.MONETARY_BENEFIT_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_046
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EGT_SETTING_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_045;

ALTER TABLE ADR.EGT_SETTING_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_045
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_PERMISSIONS_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_044;

ALTER TABLE ADR.USER_PERMISSIONS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_044
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.INSURANCE_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_043;

ALTER TABLE ADR.INSURANCE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_043
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_042;

ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_042
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_041;

ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_041
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_040;

ALTER TABLE ADR.REGISTRY_TRAIT_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_040
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_039;

ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_039
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.INELIGIBLE_RULING_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_038;

ALTER TABLE ADR.INELIGIBLE_RULING_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_038
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_PERMISSION_SETS_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_037;

ALTER TABLE ADR.USER_PERMISSION_SETS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_037
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.PERMISSION_SET_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_036;

ALTER TABLE ADR.PERMISSION_SET_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_036
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_035;

ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_035
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_RACE_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_034;

ALTER TABLE ADR.PERSON_RACE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_034
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_033;

ALTER TABLE ADR.MILITARY_SERVICE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_033
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_032;

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_032
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_031;

ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_031
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FEE_BASIS_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_030;

ALTER TABLE ADR.FEE_BASIS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_030
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CONFLICT_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_029;

ALTER TABLE ADR.CONFLICT_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_029
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.USERS_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_028;

ALTER TABLE ADR.USERS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_028
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_RELATION_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_027;

ALTER TABLE ADR.PERSON_RELATION_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_027
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_026;

ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_026
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.EMERGENCY_RESPONSE_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_025;

ALTER TABLE ADR.EMERGENCY_RESPONSE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_025
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_ROLES_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_024;

ALTER TABLE ADR.USER_ROLES_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_024
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.COMBAT_PAY_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_023;

ALTER TABLE ADR.COMBAT_PAY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_023
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.POW_REGISTRY_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_022;

ALTER TABLE ADR.POW_REGISTRY_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_022
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_021;

ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_021
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CONTACT_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_020;

ALTER TABLE ADR.PERSON_CONTACT_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_020
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_019;

ALTER TABLE ADR.SPECIAL_FACTOR_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_019
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_018;

ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_018
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_017;

ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_017
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_016;

ALTER TABLE ADR.SSN_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_016
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.USER_LOGIN_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_015;

ALTER TABLE ADR.USER_LOGIN_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_015
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_014;

ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_014
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EGT_STATISTICS_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_013;

ALTER TABLE ADR.EGT_STATISTICS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_013
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.INCOME_TEST_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_012;

ALTER TABLE ADR.INCOME_TEST_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_012
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_011;

ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_011
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_010;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_010
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_009;

ALTER TABLE ADR.PERSON_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_009
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PURPLE_HEART_REGISTRY_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_008;

ALTER TABLE ADR.PURPLE_HEART_REGISTRY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_008
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOMPETENT_RULING_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_007;

ALTER TABLE ADR.INCOMPETENT_RULING_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_007
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_TRAVEL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_006;

ALTER TABLE ADR.BENEFICIARY_TRAVEL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_006
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_005;

ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_005
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_004;

ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_004
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_ETHNICITY_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_003;

ALTER TABLE ADR.PERSON_ETHNICITY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_003
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COMBAT_EPISODE_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_002;

ALTER TABLE ADR.COMBAT_EPISODE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_002
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.BENEFICIARY_MST_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_001;

ALTER TABLE ADR.BENEFICIARY_MST_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_001
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_MESSAGING_CASE_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_000;

ALTER TABLE ADR.WKF_MESSAGING_CASE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_000
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT AVCON_1172521913_RUN_R_000;

ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT AVCON_1172521913_RUN_R_000
  CHECK (RUN_REPORT_BY_USER_FLAG BETWEEN 0
AND 0 OR RUN_REPORT_BY_USER_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.IVM_MIGRATE
  DROP CONSTRAINT AVCON_1172521913_REMIG_000;

ALTER TABLE ADR.IVM_MIGRATE ADD (
  CONSTRAINT AVCON_1172521913_REMIG_000
  CHECK (REMIGRATE_FLAG BETWEEN 0 AND 0 OR REMIGRATE_FLAG BETWEEN 1 AND 1)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_MAILING
  DROP CONSTRAINT AVCON_1172521913_REMAI_000;

ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT AVCON_1172521913_REMAI_000
  CHECK (REMAIL_STATUS_CODE IN ('REMAILED', 'RESEND'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION
  DROP CONSTRAINT AVCON_1172521913_PRIMA_001;

ALTER TABLE ADR.ELIGIBILITY_DETERMINATION ADD (
  CONSTRAINT AVCON_1172521913_PRIMA_001
  CHECK (PRIMARY_SECONDARY_OR_OTHER IN ('P', 'S', 'O'))
  ENABLE VALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY
  DROP CONSTRAINT AVCON_1172521913_PRIMA_000;

ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY ADD (
  CONSTRAINT AVCON_1172521913_PRIMA_000
  CHECK (PRIMARY_SECONDARY_OR_OTHER_IND IN ('P', 'S', 'O'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT
  DROP CONSTRAINT AVCON_1172521913_POST__000;

ALTER TABLE ADR.FINANCIAL_STATEMENT ADD (
  CONSTRAINT AVCON_1172521913_POST__000
  CHECK (POST_2005_DISPLAY_FORMAT_FLAG BETWEEN 0
AND 0 OR POST_2005_DISPLAY_FORMAT_FLAG BETWEEN 1 AND 1)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_OVERRIDE
  DROP CONSTRAINT AVCON_1172521913_OVERR_000;

ALTER TABLE ADR.ENROLLMENT_OVERRIDE ADD (
  CONSTRAINT AVCON_1172521913_OVERR_000
  CHECK (OVERRIDE_FLAG BETWEEN 0 AND 0 OR OVERRIDE_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_RELATION_MERGE
  DROP CONSTRAINT AVCON_1172521913_MERGE_002;

ALTER TABLE ADR.PERSON_RELATION_MERGE ADD (
  CONSTRAINT AVCON_1172521913_MERGE_002
  CHECK (MERGE_RECORD_LOCKED_FLAG BETWEEN 0
AND 0 OR MERGE_RECORD_LOCKED_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_RELATION_MERGE
  DROP CONSTRAINT AVCON_1172521913_MERGE_001;

ALTER TABLE ADR.PERSON_RELATION_MERGE ADD (
  CONSTRAINT AVCON_1172521913_MERGE_001
  CHECK (MERGE_IN_PROGRESS_FLAG BETWEEN 0
AND 0 OR MERGE_IN_PROGRESS_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_MERGE
  DROP CONSTRAINT AVCON_1172521913_MERGE_000;

ALTER TABLE ADR.PERSON_MERGE ADD (
  CONSTRAINT AVCON_1172521913_MERGE_000
  CHECK (MERGE_RECORD_LOCKED_FLAG BETWEEN 0
AND 0 OR MERGE_RECORD_LOCKED_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.IVM_MIGRATE
  DROP CONSTRAINT AVCON_1172521913_MARKE_000;

ALTER TABLE ADR.IVM_MIGRATE ADD (
  CONSTRAINT AVCON_1172521913_MARKE_000
  CHECK (MARKED_FLAG BETWEEN 0 AND 0 OR MARKED_FLAG BETWEEN 1 AND 1)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT AVCON_1172521913_INCLU_000;

ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT AVCON_1172521913_INCLU_000
  CHECK (INCLUDE_USERS_FLAG BETWEEN 0
AND 0 OR INCLUDE_USERS_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_ROLES
  DROP CONSTRAINT AVCON_1172521913_INACT_116;

ALTER TABLE ADR.USER_ROLES ADD (
  CONSTRAINT AVCON_1172521913_INACT_116
  CHECK (INACTIVE_FLAG BETWEEN 0 AND 0 OR INACTIVE_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.APP_PARAMETER
  DROP CONSTRAINT AVCON_1172521913_INACT_114;

ALTER TABLE ADR.APP_PARAMETER ADD (
  CONSTRAINT AVCON_1172521913_INACT_114
  CHECK (INACTIVE_FLAG BETWEEN 0 AND 0 OR INACTIVE_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLES
  DROP CONSTRAINT AVCON_1172521913_INACT_063;

ALTER TABLE ADR.ROLES ADD (
  CONSTRAINT AVCON_1172521913_INACT_063
  CHECK (INACTIVE_FLAG BETWEEN 0 AND 0 OR INACTIVE_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY
  DROP CONSTRAINT AVCON_1172521913_INACT_046;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY ADD (
  CONSTRAINT AVCON_1172521913_INACT_046
  CHECK (INACTIVE_FLAG BETWEEN 0 AND 0 OR INACTIVE_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.USERS
  DROP CONSTRAINT AVCON_1172521913_INACT_042;

ALTER TABLE ADR.USERS ADD (
  CONSTRAINT AVCON_1172521913_INACT_042
  CHECK (INACTIVE_FLAG BETWEEN 0 AND 0 OR INACTIVE_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.INCOME_TEST
  DROP CONSTRAINT AVCON_1172521913_FUTUR_001;

ALTER TABLE ADR.INCOME_TEST ADD (
  CONSTRAINT AVCON_1172521913_FUTUR_001
  CHECK (FUTURE_TEST_FLAG BETWEEN 0 AND 0 OR FUTURE_TEST_FLAG BETWEEN 1 AND 1)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_H
  DROP CONSTRAINT AVCON_1172521913_FUTUR_000;

ALTER TABLE ADR.INCOME_TEST_H ADD (
  CONSTRAINT AVCON_1172521913_FUTUR_000
  CHECK (FUTURE_TEST_FLAG BETWEEN 0 AND 0 OR FUTURE_TEST_FLAG BETWEEN 1 AND 1)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION
  DROP CONSTRAINT AVCON_1172521913_ENROL_000;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION ADD (
  CONSTRAINT AVCON_1172521913_ENROL_000
  CHECK (ENROLLMENT_OVERRIDDEN_FLAG BETWEEN 0
AND 0 OR ENROLLMENT_OVERRIDDEN_FLAG BETWEEN 1 AND 1)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EGT_SETTING
  DROP CONSTRAINT AVCON_1172521913_DISAB_000;

ALTER TABLE ADR.EGT_SETTING ADD (
  CONSTRAINT AVCON_1172521913_DISAB_000
  CHECK (DISABLED_EGT_FLAG BETWEEN 0
AND 0 OR DISABLED_EGT_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL
  DROP CONSTRAINT AVCON_1172521913_DEFAU_000;

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL ADD (
  CONSTRAINT AVCON_1172521913_DEFAU_000
  CHECK (DEFAULT_DIVISION_FLAG BETWEEN 0
AND 0 OR DEFAULT_DIVISION_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_SETTING_H
  DROP CONSTRAINT AVCON_1172521913_CURRE_001;

ALTER TABLE ADR.EGT_SETTING_H ADD (
  CONSTRAINT AVCON_1172521913_CURRE_001
  CHECK (CURRENT_EGT_FLAG BETWEEN 0 AND 0 OR CURRENT_EGT_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_SETTING
  DROP CONSTRAINT AVCON_1172521913_CURRE_000;

ALTER TABLE ADR.EGT_SETTING ADD (
  CONSTRAINT AVCON_1172521913_CURRE_000
  CHECK (CURRENT_EGT_FLAG BETWEEN 0 AND 0 OR CURRENT_EGT_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.APPOINTMENT_REQUEST
  DROP CONSTRAINT APP_REQUEST_PRSN_FK;


ALTER TABLE ADR.APPOINTMENT_REQUEST ADD (
  CONSTRAINT APP_REQUEST_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.APPOINTMENT_REQUEST_H
  DROP CONSTRAINT APP_REQUESTH_PRSN_FK;


ALTER TABLE ADR.APPOINTMENT_REQUEST_H ADD (
  CONSTRAINT APP_REQUESTH_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.APP_PARAMETER_H
  DROP CONSTRAINT APP_PARAMETER_H_PK;

ALTER TABLE ADR.APP_PARAMETER_H ADD (
  CONSTRAINT APP_PARAMETER_H_PK
  PRIMARY KEY
  (APP_PARAMETER_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ACTIVEAGG_TRACKER
  DROP CONSTRAINT APP_LOG_PK;

ALTER TABLE ADR.ACTIVEAGG_TRACKER ADD (
  CONSTRAINT APP_LOG_PK
  PRIMARY KEY
  (ACTIVEAGG_TRACKER_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.APPOINTMENT_REQUEST
  DROP CONSTRAINT APPOINTMENT_REQUEST_PK;

ALTER TABLE ADR.APPOINTMENT_REQUEST ADD (
  CONSTRAINT APPOINTMENT_REQUEST_PK
  PRIMARY KEY
  (APPOINTMENT_REQUEST_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.APPOINTMENT_REQUEST_H
  DROP CONSTRAINT APPOINTMENT_REQUEST_H_PK;

ALTER TABLE ADR.APPOINTMENT_REQUEST_H ADD (
  CONSTRAINT APPOINTMENT_REQUEST_H_PK
  PRIMARY KEY
  (APPOINTMENT_REQUEST_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.APP_PARAMETER
  DROP CONSTRAINT APPLPARAM_U_CODE_UK;

ALTER TABLE ADR.APP_PARAMETER ADD (
  CONSTRAINT APPLPARAM_U_CODE_UK
  UNIQUE (PARAMETER_NAME)
  ENABLE VALIDATE);
ALTER TABLE ADR.APP_PARAMETER
  DROP CONSTRAINT APPLPARAM_PK;

ALTER TABLE ADR.APP_PARAMETER ADD (
  CONSTRAINT APPLPARAM_PK
  PRIMARY KEY
  (APP_PARAMETER_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.APP_PARAMETER
  DROP CONSTRAINT APARAM_STD_APARAMU_FK;


ALTER TABLE ADR.APP_PARAMETER ADD (
  CONSTRAINT APARAM_STD_APARAMU_FK 
  FOREIGN KEY (APP_PARAMETER_UNIT_ID) 
  REFERENCES ADRREF.STD_APPPARAMETERUNIT (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.APP_PARAMETER
  DROP CONSTRAINT APARAM_STD_APARAMTYP_FK;


ALTER TABLE ADR.APP_PARAMETER ADD (
  CONSTRAINT APARAM_STD_APARAMTYP_FK 
  FOREIGN KEY (APP_PARAMETER_TYPE_ID) 
  REFERENCES ADRREF.STD_APPPARAMETERTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT ADR_SITE_OF_CNG_FK;


ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT ADR_SITE_OF_CNG_FK 
  FOREIGN KEY (SITE_OF_CHANGE_ID) 
  REFERENCES ADR.LOOKUP_TYPE (LOOKUP_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ADR_DB_VER
  DROP CONSTRAINT ADR_DBVER_VERSION_UK;

ALTER TABLE ADR.ADR_DB_VER ADD (
  CONSTRAINT ADR_DBVER_VERSION_UK
  UNIQUE (DB_VERSION, ADR_CR)
  ENABLE VALIDATE);
ALTER TABLE ADR.ADR_DB_VER
  DROP CONSTRAINT ADR_DBVER_PK;

ALTER TABLE ADR.ADR_DB_VER ADD (
  CONSTRAINT ADR_DBVER_PK
  PRIMARY KEY
  (ADR_DB_VER_ID)
  DISABLE NOVALIDATE);
ALTER TABLE ADR.ADR_DB_VER
  DROP CONSTRAINT ADR_DBVER_CR_UK;

ALTER TABLE ADR.ADR_DB_VER ADD (
  CONSTRAINT ADR_DBVER_CR_UK
  UNIQUE (ADR_CR)
  ENABLE VALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT ADDR_STD_NCOAZIPNOMTCH_FK;


ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT ADDR_STD_NCOAZIPNOMTCH_FK 
  FOREIGN KEY (NCOA_ZIP_NO_MATCH_TYPE_ID) 
  REFERENCES ADRREF.STD_NCOAZIPNOMATCHTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT ADDR_STD_NCOAZIPMCH_FK;


ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT ADDR_STD_NCOAZIPMCH_FK 
  FOREIGN KEY (NCOA_ZIP_MATCH_TYPE_ID) 
  REFERENCES ADRREF.STD_NCOAZIPMATCHTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT ADDR_STD_NCOASTATYP_FK;


ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT ADDR_STD_NCOASTATYP_FK 
  FOREIGN KEY (NCOA_STATUS_TYPE_ID) 
  REFERENCES ADRREF.STD_NCOASTATUSTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT ADDR_STD_NCOADELTYP_FK;


ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT ADDR_STD_NCOADELTYP_FK 
  FOREIGN KEY (NCOA_DELIVERY_TYPE_ID) 
  REFERENCES ADRREF.STD_NCOADELIVERYTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT ADDR_PRSN_FK;


ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT ADDR_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT ADDR_PRSNREL_FK;


ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT ADDR_PRSNREL_FK 
  FOREIGN KEY (PERSON_RELATION_ID) 
  REFERENCES ADR.PERSON_RELATION (PERSON_RELATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT ADDR_PK;

ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT ADDR_PK
  PRIMARY KEY
  (ADDRESS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT ADDR_INSURANCE_FK;


ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT ADDR_INSURANCE_FK 
  FOREIGN KEY (INSURANCE_ID) 
  REFERENCES ADR.INSURANCE (INSURANCE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS_H
  DROP CONSTRAINT ADDR_H_CASSCERTIFIEDTY_FK;


ALTER TABLE ADR.ADDRESS_H ADD (
  CONSTRAINT ADDR_H_CASSCERTIFIEDTY_FK 
  FOREIGN KEY (CASSCERTIFIEDTYPE_ID) 
  REFERENCES ADR.CASSCERTIFIEDTYPE (CASSCERTIFIEDTYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H
  DROP CONSTRAINT ADDR_CONFIDENTIAL_DTL_H_CHK;

ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H ADD (
  CONSTRAINT ADDR_CONFIDENTIAL_DTL_H_CHK
  CHECK (TRANSACTION_TYPE_CODE IN ('''U''', '''I''', '''D'''))
  ENABLE VALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT ADDR_CASSCERTIFIEDTY_FK;


ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT ADDR_CASSCERTIFIEDTY_FK 
  FOREIGN KEY (CASSCERTIFIEDTYPE_ID) 
  REFERENCES ADR.CASSCERTIFIEDTYPE (CASSCERTIFIEDTYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS_H
  DROP CONSTRAINT ADDRH_PK;

ALTER TABLE ADR.ADDRESS_H ADD (
  CONSTRAINT ADDRH_PK
  PRIMARY KEY
  (ADDRESS_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL
  DROP CONSTRAINT ADDRCONF_PK;

ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL ADD (
  CONSTRAINT ADDRCONF_PK
  PRIMARY KEY
  (ADDR_CONFIDENTIAL_DTL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL
  DROP CONSTRAINT ADDRCONF_ADDR_FK;


ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL ADD (
  CONSTRAINT ADDRCONF_ADDR_FK 
  FOREIGN KEY (ADDRESS_ID) 
  REFERENCES ADR.ADDRESS (ADDRESS_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H
  DROP CONSTRAINT ADDRCONFH_PK;

ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H ADD (
  CONSTRAINT ADDRCONFH_PK
  PRIMARY KEY
  (ADDR_CONFIDENTIAL_DTL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ACTIVATION
  DROP CONSTRAINT ACT_PK;

ALTER TABLE ADR.ACTIVATION ADD (
  CONSTRAINT ACT_PK
  PRIMARY KEY
  (ACTIVATION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ACTIVATION_H
  DROP CONSTRAINT ACT_H_PK;

ALTER TABLE ADR.ACTIVATION_H ADD (
  CONSTRAINT ACT_H_PK
  PRIMARY KEY
  (ACTIVATION_H_ID)
  ENABLE VALIDATE);
